"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      font
    } = euiTheme;
    const titleSection = {
      marginBottom: size.l
    };
    const titleText = {
      display: 'flex',
      alignItems: 'center'
    };
    const titleActions = {
      marginLeft: 'auto',
      flexDirection: 'row',
      alignItems: 'center'
    };
    const updatedAt = {
      marginRight: size.m
    };
    const widgetBadge = {
      position: 'absolute',
      bottom: size.base,
      left: size.base,
      width: `calc(100% - ${size.xl})`,
      fontSize: size.m,
      lineHeight: '18px',
      padding: `${size.xs} ${size.s}`,
      display: 'flex'
    };
    const treeViewContainer = {
      position: 'relative',
      border: euiTheme.border.thin,
      borderRadius: euiTheme.border.radius.medium,
      padding: size.base,
      height: '500px'
    };
    const widgetsBottomSpacing = {
      marginBottom: size.m
    };
    const countWidgetsGroup = {
      ...widgetsBottomSpacing,
      flexWrap: 'wrap',
      [`@media (max-width:${euiTheme.breakpoint.xl}px)`]: {
        flexDirection: 'column'
      }
    };
    const leftWidgetsGroup = {
      [`@media (max-width:${euiTheme.breakpoint.xl}px)`]: {
        marginBottom: '0 !important'
      },
      minWidth: `calc(70% - ${size.xxxl})`
    };
    const rightWidgetsGroup = {
      [`@media (max-width:${euiTheme.breakpoint.xl}px)`]: {
        marginTop: '0 !important'
      },
      minWidth: '30%'
    };
    const percentageChartTitle = {
      marginRight: size.xs,
      display: 'inline',
      fontWeight: font.weight.bold
    };
    const widgetsGroup = {
      [`@media (max-width:${euiTheme.breakpoint.xl}px)`]: {
        flexDirection: 'column'
      }
    };
    return {
      titleSection,
      titleText,
      titleActions,
      updatedAt,
      widgetBadge,
      treeViewContainer,
      countWidgetsGroup,
      leftWidgetsGroup,
      rightWidgetsGroup,
      widgetsBottomSpacing,
      percentageChartTitle,
      widgetsGroup
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;