"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.KubernetesSecurityRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../../common/constants");
var _percent_widget = require("../percent_widget");
var _count_widget = require("../count_widget");
var _hooks = require("../../hooks");
var _styles = require("./styles");
var _tree_view_container = require("../tree_view_container");
var _charts_toggle = require("../charts_toggle");
var _translations = require("../../../common/translations");
var _container_name_widget = require("../container_name_widget");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/kubernetes_security/public/components/kubernetes_security_routes/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KubernetesSecurityRoutesComponent = ({
  dataViewId,
  filter,
  indexPattern,
  globalFilter,
  renderSessionsView
}) => {
  const [shouldHideCharts, setShouldHideCharts] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_HIDE_WIDGETS_KEY, false);
  const styles = (0, _styles.useStyles)();
  const lastUpdated = (0, _hooks.useLastUpdated)(globalFilter);
  const onReduceInteractiveAggs = (0, _react.useCallback)(result => result.buckets.reduce((groupedByKeyValue, aggregate) => {
    var _aggregate$count_by_a, _aggregate$count_by_a2;
    groupedByKeyValue[aggregate.key_as_string || aggregate.key.toString()] = (_aggregate$count_by_a = (_aggregate$count_by_a2 = aggregate.count_by_aggs) === null || _aggregate$count_by_a2 === void 0 ? void 0 : _aggregate$count_by_a2.value) !== null && _aggregate$count_by_a !== void 0 ? _aggregate$count_by_a : 0;
    return groupedByKeyValue;
  }, {}), []);
  const onReduceRootAggs = (0, _react.useCallback)(result => result.buckets.reduce((groupedByKeyValue, aggregate) => {
    if (aggregate.key.toString() === '0') {
      var _aggregate$count_by_a3, _aggregate$count_by_a4;
      groupedByKeyValue[aggregate.key] = (_aggregate$count_by_a3 = (_aggregate$count_by_a4 = aggregate.count_by_aggs) === null || _aggregate$count_by_a4 === void 0 ? void 0 : _aggregate$count_by_a4.value) !== null && _aggregate$count_by_a3 !== void 0 ? _aggregate$count_by_a3 : 0;
    } else {
      var _aggregate$count_by_a5, _aggregate$count_by_a6;
      groupedByKeyValue.nonRoot = (groupedByKeyValue.nonRoot || 0) + ((_aggregate$count_by_a5 = (_aggregate$count_by_a6 = aggregate.count_by_aggs) === null || _aggregate$count_by_a6 === void 0 ? void 0 : _aggregate$count_by_a6.value) !== null && _aggregate$count_by_a5 !== void 0 ? _aggregate$count_by_a5 : 0);
    }
    return groupedByKeyValue;
  }, {}), []);
  const handleToggleHideCharts = (0, _react.useCallback)(() => {
    setShouldHideCharts(!shouldHideCharts);
  }, [setShouldHideCharts, shouldHideCharts]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: _constants.KUBERNETES_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, filter, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: styles.titleSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    css: styles.titleText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }, _constants.KUBERNETES_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.titleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.updatedAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, lastUpdated), /*#__PURE__*/_react.default.createElement(_charts_toggle.ChartsToggle, {
    shouldHideCharts: shouldHideCharts,
    handleToggleHideCharts: handleToggleHideCharts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }))), !shouldHideCharts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.widgetsGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.leftWidgetsGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.countWidgetsGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_CLUSTERS,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_CLUSTERS,
    groupedBy: _constants.ORCHESTRATOR_CLUSTER_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_NAMESPACE,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NAMESPACE,
    groupedBy: _constants.ORCHESTRATOR_NAMESPACE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_NODES,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NODES,
    groupedBy: _constants.CLOUD_INSTANCE_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_PODS,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NODES,
    groupedBy: _constants.ORCHESTRATOR_RESOURCE_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_CONTAINER_IMAGES,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_CONTAINER_IMAGES,
    groupedBy: _constants.CONTAINER_IMAGE_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.widgetsBottomSpacing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_percent_widget.PercentWidget, {
    dataViewId: dataViewId,
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: styles.percentageChartTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.kubernetesSecurity.sessionChart.title",
      defaultMessage: "Session interactivity",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 29
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.kubernetesSecurity.sessionChart.tooltip",
        defaultMessage: "Interactive sessions have a controlling terminal and often imply that a human is entering the commands.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 31
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 27
      }
    })),
    widgetKey: "sessionsPercentage",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    dataValueMap: {
      true: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.sessionChart.interactive', {
          defaultMessage: 'Interactive'
        }),
        fieldName: _constants.ENTRY_LEADER_INTERACTIVE,
        color: _uiTheme.euiThemeVars.euiColorVis0
      },
      false: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.sessionChart.nonInteractive', {
          defaultMessage: 'Non-interactive'
        }),
        fieldName: _constants.ENTRY_LEADER_INTERACTIVE,
        color: _uiTheme.euiThemeVars.euiColorVis1,
        shouldHideFilter: true
      }
    },
    groupedBy: _constants.ENTRY_LEADER_INTERACTIVE,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID,
    onReduce: onReduceInteractiveAggs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_percent_widget.PercentWidget, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: styles.percentageChartTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.kubernetesSecurity.entryUserChart.title",
      defaultMessage: "Entry session users",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 29
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.kubernetesSecurity.entryUserChart.tooltip",
        defaultMessage: "The entry session user is the initial Linux user associated with the session. This user may be set from authentication of a remote login or automatically for service sessions started by init.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 31
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 27
      }
    })),
    widgetKey: "rootLoginPercentage",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    dataValueMap: {
      '0': {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.entryUserChart.root', {
          defaultMessage: 'Root'
        }),
        fieldName: _constants.ENTRY_LEADER_USER_ID,
        color: _uiTheme.euiThemeVars.euiColorVis2
      },
      nonRoot: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.entryUserChart.nonRoot', {
          defaultMessage: 'Non-root'
        }),
        fieldName: _constants.ENTRY_LEADER_USER_ID,
        color: _uiTheme.euiThemeVars.euiColorVis3,
        shouldHideFilter: true
      }
    },
    dataViewId: dataViewId,
    groupedBy: _constants.ENTRY_LEADER_USER_ID,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID,
    onReduce: onReduceRootAggs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.rightWidgetsGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_container_name_widget.ContainerNameWidget, {
    dataViewId: dataViewId,
    widgetKey: "containerNameSessions",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    groupedBy: _constants.CONTAINER_IMAGE_NAME,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_tree_view_container.TreeViewContainer, {
    globalFilter: globalFilter,
    renderSessionsView: renderSessionsView,
    indexPattern: indexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  })));
};
const KubernetesSecurityRoutes = exports.default = exports.KubernetesSecurityRoutes = /*#__PURE__*/_react.default.memo(KubernetesSecurityRoutesComponent);
// eslint-disable-next-line import/no-default-export