"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedKey = FormattedKey;
exports.FormattedValue = FormattedValue;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-key-value-metadata-table/src/formatted_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmptyValue = _styled.default.span`
  color: ${({
  theme
}) => theme.euiTheme.colors.mediumShade};
  text-align: left;
`;
function FormattedKey({
  k,
  value
}) {
  if (value == null) {
    return /*#__PURE__*/_react.default.createElement(EmptyValue, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 12
      }
    }, k);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 10
    }
  }, k);
}
function FormattedValue({
  value
}) {
  if ((0, _lodash.isObject)(value)) {
    return /*#__PURE__*/_react.default.createElement("pre", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 12
      }
    }, JSON.stringify(value, null, 4));
  } else if ((0, _lodash.isBoolean)(value) || (0, _lodash.isNumber)(value)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    }, String(value));
  } else if (!value) {
    return /*#__PURE__*/_react.default.createElement(EmptyValue, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('keyValueMetadataTable.notAvailableLabel', {
      defaultMessage: 'N/A'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 10
    }
  }, value);
}