"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubmitErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/submit_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SubmitErrorCallout = props => {
  var _error$body, _error$body2, _error$body2$attribut, _error$body3, _error$body3$attribut, _error$body4, _error$body5, _error$body5$attribut, _error$body6, _error$body6$attribut, _error$body7, _error$body7$attribut, _error$body8, _error$body9, _error$body9$attribut, _error$body10, _error$body10$attribu, _error$body11, _error$body11$attribu, _error$body12, _error$body12$attribu, _error$body13, _error$body13$attribu, _error$body14, _error$body14$attribu, _error$body15, _error$body15$attribu, _error$body16, _error$body16$attribu, _error$body17;
  const error = props.error;
  if (((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404 || ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$attribut = _error$body2.attributes) === null || _error$body2$attribut === void 0 ? void 0 : _error$body2$attribut.type) === _common.ERROR_OUTSIDE_PREBOOT_STAGE || ((_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : (_error$body3$attribut = _error$body3.attributes) === null || _error$body3$attribut === void 0 ? void 0 : _error$body3$attribut.type) === _common.ERROR_ELASTICSEARCH_CONNECTION_CONFIGURED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      color: "primary",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "interactiveSetup.submitErrorCallout.elasticsearchConnectionConfiguredErrorTitle",
        defaultMessage: "Elastic is already configured",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        const url = new URL(window.location.href);
        url.searchParams.delete('code');
        window.location.replace(url.href);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.submitErrorCallout.elasticsearchConnectionConfiguredSubmitButton",
      defaultMessage: "Continue to Kibana",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: ((_error$body4 = error.body) === null || _error$body4 === void 0 ? void 0 : _error$body4.statusCode) === 403 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.submitErrorCallout.forbiddenErrorTitle",
      defaultMessage: "Verification required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }) : ((_error$body5 = error.body) === null || _error$body5 === void 0 ? void 0 : (_error$body5$attribut = _error$body5.attributes) === null || _error$body5$attribut === void 0 ? void 0 : _error$body5$attribut.type) === _common.ERROR_KIBANA_CONFIG_NOT_WRITABLE || ((_error$body6 = error.body) === null || _error$body6 === void 0 ? void 0 : (_error$body6$attribut = _error$body6.attributes) === null || _error$body6$attribut === void 0 ? void 0 : _error$body6$attribut.type) === _common.ERROR_KIBANA_CONFIG_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.submitErrorCallout.kibanaConfigNotWritableErrorTitle",
      defaultMessage: "Couldn't write to config file",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }) : ((_error$body7 = error.body) === null || _error$body7 === void 0 ? void 0 : (_error$body7$attribut = _error$body7.attributes) === null || _error$body7$attribut === void 0 ? void 0 : _error$body7$attribut.type) === _common.ERROR_PING_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.submitErrorCallout.pingFailureErrorTitle",
      defaultMessage: "Couldn't connect to cluster",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }) : props.defaultTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, ((_error$body8 = error.body) === null || _error$body8 === void 0 ? void 0 : _error$body8.statusCode) === 403 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.forbiddenErrorDescription",
    defaultMessage: "Retry to configure Elastic.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }) : ((_error$body9 = error.body) === null || _error$body9 === void 0 ? void 0 : (_error$body9$attribut = _error$body9.attributes) === null || _error$body9$attribut === void 0 ? void 0 : _error$body9$attribut.type) === _common.ERROR_KIBANA_CONFIG_NOT_WRITABLE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.kibanaConfigNotWritableErrorDescription",
    defaultMessage: "Check the file permissions and ensure {config} is writable by the Kibana process.",
    values: {
      config: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 21
        }
      }, "kibana.yml")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }) : ((_error$body10 = error.body) === null || _error$body10 === void 0 ? void 0 : (_error$body10$attribu = _error$body10.attributes) === null || _error$body10$attribu === void 0 ? void 0 : _error$body10$attribu.type) === _common.ERROR_KIBANA_CONFIG_FAILURE || ((_error$body11 = error.body) === null || _error$body11 === void 0 ? void 0 : (_error$body11$attribu = _error$body11.attributes) === null || _error$body11$attribu === void 0 ? void 0 : _error$body11$attribu.type) === _common.ERROR_CONFIGURE_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.kibanaConfigFailureErrorDescription",
    defaultMessage: "Retry or update the {config} file manually.",
    values: {
      config: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 21
        }
      }, "kibana.yml")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }) : ((_error$body12 = error.body) === null || _error$body12 === void 0 ? void 0 : (_error$body12$attribu = _error$body12.attributes) === null || _error$body12$attribu === void 0 ? void 0 : _error$body12$attribu.type) === _common.ERROR_ENROLL_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.EnrollFailureErrorDescription",
    defaultMessage: "Generate a new enrollment token or configure manually.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }) : ((_error$body13 = error.body) === null || _error$body13 === void 0 ? void 0 : (_error$body13$attribu = _error$body13.attributes) === null || _error$body13$attribu === void 0 ? void 0 : _error$body13$attribu.type) === _common.ERROR_PING_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.pingFailureErrorDescription",
    defaultMessage: "Check the address and retry.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }) : ((_error$body14 = error.body) === null || _error$body14 === void 0 ? void 0 : (_error$body14$attribu = _error$body14.attributes) === null || _error$body14$attribu === void 0 ? void 0 : _error$body14$attribu.type) === _common.ERROR_COMPATIBILITY_FAILURE ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.submitErrorCallout.compatibilityFailureErrorDescription",
    defaultMessage: "The Elasticsearch cluster (v{elasticsearchVersion}) is incompatible with this version of Kibana (v{kibanaVersion}).",
    values: {
      elasticsearchVersion: (_error$body15 = error.body) === null || _error$body15 === void 0 ? void 0 : (_error$body15$attribu = _error$body15.attributes) === null || _error$body15$attribu === void 0 ? void 0 : _error$body15$attribu.elasticsearchVersion,
      kibanaVersion: (_error$body16 = error.body) === null || _error$body16 === void 0 ? void 0 : (_error$body16$attribu = _error$body16.attributes) === null || _error$body16$attribu === void 0 ? void 0 : _error$body16$attribu.kibanaVersion
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }) : ((_error$body17 = error.body) === null || _error$body17 === void 0 ? void 0 : _error$body17.message) || error.message);
};
exports.SubmitErrorCallout = SubmitErrorCallout;