"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForgotPasswordPopover = exports.ClusterConfigurationForm = exports.CertificatePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _get_command_line_snippet = require("./get_command_line_snippet");
var _submit_error_callout = require("./submit_error_callout");
var _text_truncate = require("./text_truncate");
var _use_form = require("./use_form");
var _use_html_id = require("./use_html_id");
var _use_kibana = require("./use_kibana");
var _use_verification = require("./use_verification");
var _use_visibility = require("./use_visibility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/cluster_configuration_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ClusterConfigurationForm = ({
  host,
  authRequired,
  certificateChain,
  defaultValues = {
    username: 'kibana_system',
    password: '',
    caCert: ''
  },
  onCancel,
  onSuccess
}) => {
  const {
    http,
    docLinks
  } = (0, _use_kibana.useKibana)();
  const {
    status,
    getCode
  } = (0, _use_verification.useVerification)();
  const [form, eventHandlers] = (0, _use_form.useForm)({
    defaultValues,
    validate: values => {
      const errors = {};
      if (authRequired) {
        if (!values.username) {
          errors.username = _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.usernameRequiredError', {
            defaultMessage: 'Enter a username.'
          });
        } else if (values.username === 'elastic') {
          errors.username = _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.usernameReservedError', {
            defaultMessage: "User 'elastic' can't be used as the Kibana system user."
          });
        }
        if (!values.password) {
          errors.password = _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.passwordRequiredError', {
            defaultMessage: 'Enter a password.'
          });
        }
      }
      if (certificateChain && certificateChain.length > 0 && !values.caCert) {
        errors.caCert = _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.caCertConfirmationRequiredError', {
          defaultMessage: 'Confirm that you recognize and trust this certificate.'
        });
      }
      return errors;
    },
    onSubmit: async values => {
      await http.post('/internal/interactive_setup/configure', {
        body: JSON.stringify({
          host,
          username: authRequired ? values.username : undefined,
          password: authRequired ? values.password : undefined,
          caCert: certificateChain && certificateChain.length > 0 ? values.caCert : undefined,
          code: getCode()
        })
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    }
  });
  const [isVisible, buttonRef] = (0, _use_visibility.useVisibility)();
  const trustCaCertId = (0, _use_html_id.useHtmlId)('clusterConfigurationForm', 'trustCaCert');
  (0, _useUpdateEffect.default)(() => {
    if (status === 'verified' && isVisible) {
      form.submit();
    }
  }, [status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({
    component: "form",
    noValidate: true
  }, eventHandlers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }), status !== 'unverified' && !form.isSubmitting && !form.isValidating && form.submitError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_submit_error_callout.SubmitErrorCallout, {
    error: form.submitError,
    defaultTitle: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.submitErrorTitle', {
      defaultMessage: "Couldn't configure Elastic"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterConfigurationForm.connectTo",
    defaultMessage: "Connect to",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_text_truncate.TextTruncate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, host)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), authRequired ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.usernameLabel', {
      defaultMessage: 'Username'
    }),
    error: form.errors.username,
    isInvalid: form.touched.username && !!form.errors.username,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    icon: "user",
    name: "username",
    value: form.values.username,
    isInvalid: form.touched.username && !!form.errors.username,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.passwordLabel', {
      defaultMessage: 'Password'
    }),
    error: form.errors.password,
    isInvalid: form.touched.password && !!form.errors.password,
    helpText: form.errors.username ? undefined : /*#__PURE__*/_react.default.createElement(ForgotPasswordPopover, {
      username: form.values.username,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 17
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    type: "dual",
    name: "password",
    value: form.values.password,
    isInvalid: form.touched.password && !!form.errors.password,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.insecureClusterTitle', {
      defaultMessage: 'This cluster is not secure'
    }),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "div",
    id: "interactiveSetup.clusterConfigurationForm.insecureClusterDescription",
    defaultMessage: "Anyone with the address can access your data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.security.enableElasticSearchSecurityFeatures,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterConfigurationForm.insecureClusterLink",
    defaultMessage: "Learn how to enable security features.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  })), certificateChain && certificateChain.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.caCertLabel', {
      defaultMessage: 'Certificate authority'
    }),
    error: form.errors.caCert,
    isInvalid: form.touched.caCert && !!form.errors.caCert,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: trustCaCertId,
    label: _i18n.i18n.translate('interactiveSetup.clusterConfigurationForm.trustCaCertLabel', {
      defaultMessage: 'I recognize and trust this certificate:'
    }),
    checkableType: "checkbox",
    value: "true",
    checked: !!form.values.caCert,
    onChange: () => {
      const rootCa = certificateChain[certificateChain.length - 1];
      form.setTouched('caCert');
      form.setValue('caCert', form.values.caCert ? '' : rootCa.raw);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CertificateChain, {
    certificateChain: certificateChain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    iconType: "arrowLeft",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterConfigurationForm.cancelButton",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    buttonRef: buttonRef,
    type: "submit",
    isLoading: form.isSubmitting,
    isDisabled: form.isSubmitted && form.isInvalid,
    color: "primary",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterConfigurationForm.submitButton",
    defaultMessage: "{isSubmitting, select, true{Configuring Elastic\u2026} other{Configure Elastic}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 13
    }
  })))));
};
exports.ClusterConfigurationForm = ClusterConfigurationForm;
const CertificatePanel = ({
  certificate,
  onClick,
  type,
  compressed = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: compressed ? 'subdued' : undefined,
    hasBorder: !compressed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "document",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 17
    }
  }, certificate.subject.O || certificate.subject.CN))), !compressed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 17
    }
  }, type === 'root' ? _i18n.i18n.translate('interactiveSetup.certificatePanel.rootCertificateAuthority', {
    defaultMessage: 'Root CA'
  }) : type === 'intermediate' ? _i18n.i18n.translate('interactiveSetup.certificatePanel.intermediateCertificateAuthority', {
    defaultMessage: 'Intermediate CA'
  }) : _i18n.i18n.translate('interactiveSetup.certificatePanel.serverCertificate', {
    defaultMessage: 'Server certificate'
  })))), compressed && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificatePanel.issuer",
    defaultMessage: "Issued by: {issuer}",
    values: {
      issuer: onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 370,
          columnNumber: 21
        }
      }, certificate.issuer.O || certificate.issuer.CN) : certificate.issuer.O || certificate.issuer.CN
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 15
    }
  })), !compressed && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificatePanel.validFrom",
    defaultMessage: "Issued on: {validFrom}",
    values: {
      validFrom: certificate.valid_from
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificatePanel.validTo",
    defaultMessage: "Expires on: {validTo}",
    values: {
      validTo: certificate.valid_to
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 13
    }
  })), !compressed && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificatePanel.fingerprint",
    defaultMessage: "Fingerprint (SHA-256): {fingerprint}",
    values: {
      fingerprint: certificate.fingerprint256.replace(/\:/g, ' ')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 15
    }
  })))));
};
exports.CertificatePanel = CertificatePanel;
const CertificateChain = ({
  certificateChain
}) => {
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CertificatePanel, {
    certificate: certificateChain[0],
    onClick: () => setShowModal(true),
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 7
    }
  }), showModal && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: () => setShowModal(false),
    maxWidth: _uiTheme.euiThemeVars.euiBreakpoints.s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificateChain.title",
    defaultMessage: "Certificate chain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 11
    }
  }, certificateChain.slice().reverse().map(({
    raw,
    ...certificate
  }, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortDown",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(CertificatePanel, {
    certificate: certificate,
    type: i === 0 ? 'root' : i < certificateChain.length - 1 ? 'intermediate' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => setShowModal(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 476,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.certificateChain.cancelButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 477,
      columnNumber: 15
    }
  })))));
};
const ForgotPasswordPopover = ({
  username
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setIsPopoverOpen(isOpen => !isOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 499,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.forgotPasswordPopover.buttonText",
    defaultMessage: "Forgot password?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 500,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    anchorPosition: "rightCenter",
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 514,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 515,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.forgotPasswordPopover.helpText",
    defaultMessage: "To reset the password for the {username} user, run the following command from the Elasticsearch installation directory:",
    values: {
      username: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 521,
          columnNumber: 25
        }
      }, username)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    paddingSize: "m",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 9
    }
  }, (0, _get_command_line_snippet.getCommandLineSnippet)('elasticsearch-reset-password', `--username ${username}`))));
};
exports.ForgotPasswordPopover = ForgotPasswordPopover;