"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var React = _interopRequireWildcard(require("react"));
var _presentationUtil = require("@kbn/presentation-util");
var _view_registry = require("./view_registry");
var _views = require("./views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const closeButtonLabel = _i18n.i18n.translate('inspector.closeButton', {
  defaultMessage: 'Close Inspector'
});
class InspectorPublicPlugin {
  constructor(_initializerContext) {
    (0, _defineProperty2.default)(this, "views", void 0);
  }
  setup(_core) {
    this.views = new _view_registry.InspectorViewRegistry();
    this.views.register((0, _views.getRequestsViewDescription)());
    return {
      registerView: this.views.register.bind(this.views)
    };
  }
  start(core, startDeps) {
    const isAvailable = adapters => this.views.getVisible(adapters).length > 0;
    const open = (adapters, options = {}, parentApi) => {
      const views = this.views.getVisible(adapters);

      // Don't open inspector if there are no views available for the passed adapters
      if (!views || views.length === 0) {
        throw new Error(`Tried to open an inspector without views being available.
          Make sure to call Inspector.isAvailable() with the same adapters before to check
          if an inspector can be shown.`);
      }
      const flyoutRef = (0, _presentationUtil.openLazyFlyout)({
        core,
        parentApi,
        loadContent: async () => {
          const {
            InspectorPanel
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
          return /*#__PURE__*/React.createElement(InspectorPanel, {
            views: views,
            adapters: adapters,
            title: options.title,
            options: options.options,
            dependencies: {
              application: core.application,
              http: core.http,
              uiSettings: core.uiSettings,
              share: startDeps.share,
              settings: core.settings,
              theme: core.theme
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 94,
              columnNumber: 13
            }
          });
        },
        flyoutProps: {
          'data-test-subj': 'inspectorPanel',
          'aria-labelledby': 'inspector-panel-title',
          closeButtonProps: {
            'aria-label': closeButtonLabel
          },
          size: 'm',
          paddingSize: 'l',
          type: 'overlay',
          ...options.flyoutProps
        }
      });
      return flyoutRef;
    };
    return {
      isAvailable,
      open
    };
  }
  stop() {}
}
exports.InspectorPublicPlugin = InspectorPublicPlugin;