"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Error = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_create_from_csv/error_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Error = ({
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: error.title,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "errorCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.errorMessage",
    defaultMessage: "{message}",
    values: {
      message: error.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 9
    }
  })));
};
exports.Error = Error;