"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFormFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _bulk_request_panel = require("./bulk_request_panel");
var _collapsible_panel = require("./collapsible_panel");
var _shared_imports = require("../../../shared_imports");
var _pipeline_editor = require("../pipeline_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/pipeline_form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const FormRow = (0, _shared_imports.getFormRow)({
  titleTag: 'h3'
});
const COLUMN_MAX_WIDTH = 420;
const useStyles = () => {
  const shouldHaveFixedWidth = (0, _eui.useIsWithinBreakpoints)(['l', 'xl']);
  return {
    flexItem: shouldHaveFixedWidth ? (0, _react2.css)`
          max-width: ${COLUMN_MAX_WIDTH}px;
        ` : undefined
  };
};
const PipelineFormFields = ({
  processors,
  onFailure,
  onLoadJson,
  onProcessorsUpdate,
  hasVersion,
  hasMeta,
  onEditorFlyoutOpen,
  canEditName,
  isEditing
}) => {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.nameTitle",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 16
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.nameDescription",
      defaultMessage: "A unique identifier for this pipeline.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "name",
    componentProps: {
      ['data-test-subj']: 'nameField',
      euiFieldProps: {
        disabled: canEditName === false || Boolean(isEditing)
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.descriptionFieldTitle",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.descriptionFieldDescription",
      defaultMessage: "A description of what this pipeline does.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "description",
    componentProps: {
      ['data-test-subj']: 'descriptionField',
      euiFieldProps: {
        compressed: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_editor.ProcessorsEditorContextProvider, {
    onFlyoutOpen: onEditorFlyoutOpen,
    onUpdate: onProcessorsUpdate,
    value: {
      processors,
      onFailure
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_editor.PipelineEditor, {
    onLoadJson: onLoadJson,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.flexItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.versionCardTitle",
      defaultMessage: "Add version number",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    }))),
    fieldName: "version",
    toggleProps: {
      'data-test-subj': 'versionToggle'
    },
    accordionProps: {
      'data-test-subj': 'versionAccordion'
    },
    initialToggleState: hasVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, ({
    isEnabled
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "version",
    componentProps: {
      ['data-test-subj']: 'versionField',
      euiFieldProps: {
        disabled: !isEnabled
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.form.metadataCardTitle",
      defaultMessage: "Add metadata",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    }))),
    fieldName: "_meta",
    toggleProps: {
      'data-test-subj': 'metaToggle'
    },
    accordionProps: {
      'data-test-subj': 'metaAccordion'
    },
    initialToggleState: hasMeta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, ({
    isEnabled
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.metaDescription",
    defaultMessage: "Any additional information about the ingest pipeline. This information is stored in the cluster state, so best to keep it short.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "_meta",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        readOnly: true,
        'data-test-subj': 'metaEditor',
        height: '200px',
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.form.metaAriaLabel', {
          defaultMessage: '_meta field data editor'
        }),
        options: {
          readOnly: !isEnabled,
          lineNumbers: 'off',
          tabSize: 2,
          automaticLayout: true
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_bulk_request_panel.BulkRequestPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }))));
};
exports.PipelineFormFields = PipelineFormFields;