"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Kv = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/kv.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fieldsConfig = {
  /* Required fields config */
  field_split: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.fieldSplitFieldLabel', {
      defaultMessage: 'Field split'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.kvForm.fieldSplitHelpText",
      defaultMessage: "Regex pattern used to delimit the key-value pairs. Typically a space character ({space}).",
      values: {
        space: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 18
          }
        }, '" "')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }),
    validations: [{
      validator: (0, _shared.isEmptyString)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.fieldSplitRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  value_split: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.valueSplitFieldLabel', {
      defaultMessage: 'Value split'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.kvForm.valueSplitHelpText",
      defaultMessage: "Regex pattern used to split keys and values. Typically an assignment operator ({equal}).",
      values: {
        equal: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 18
          }
        }, '"="')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    }),
    validations: [{
      validator: (0, _shared.isEmptyString)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.valueSplitRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  /* Optional fields config */
  include_keys: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.includeKeysFieldLabel', {
      defaultMessage: 'Include keys'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.includeKeysHelpText', {
      defaultMessage: 'List of extracted keys to include in the output. Defaults to all keys.'
    })
  },
  exclude_keys: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.excludeKeysFieldLabel', {
      defaultMessage: 'Exclude keys'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.excludeKeysHelpText', {
      defaultMessage: 'List of extracted keys to exclude from the output.'
    })
  },
  prefix: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.prefixFieldLabel', {
      defaultMessage: 'Prefix'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.prefixHelpText', {
      defaultMessage: 'Prefix to add to extracted keys.'
    })
  },
  trim_key: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.trimKeyFieldLabel', {
      defaultMessage: 'Trim key'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.trimKeyHelpText', {
      defaultMessage: 'Characters to trim from extracted keys.'
    })
  },
  trim_value: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.trimValueFieldLabel', {
      defaultMessage: 'Trim value'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.trimValueHelpText', {
      defaultMessage: 'Characters to trim from extracted values.'
    })
  },
  strip_brackets: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.stripBracketsFieldLabel', {
      defaultMessage: 'Strip brackets'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.kvForm.stripBracketsHelpText",
      defaultMessage: "Remove brackets ( {paren}, {angle}, {square}) and quotes ({singleQuote}, {doubleQuote}) from extracted values.",
      values: {
        paren: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 18
          }
        }, '()'),
        angle: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 18
          }
        }, "<>"),
        square: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 19
          }
        }, '[]'),
        singleQuote: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 24
          }
        }, "'"),
        doubleQuote: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 24
          }
        }, '"')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    })
  }
};
const Kv = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.fieldNameHelpText', {
      defaultMessage: 'Field containing a string of key-value pairs.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.field_split,
    path: "fields.field_split",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.value_split,
    path: "fields.value_split",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.kvForm.targetFieldHelpText', {
      defaultMessage: 'Output field for the extracted fields. Defaults to the document root.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ComboBoxField,
    config: fieldsConfig.include_keys,
    path: "fields.include_keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ComboBoxField,
    config: fieldsConfig.exclude_keys,
    path: "fields.exclude_keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.prefix,
    path: "fields.prefix",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.trim_key,
    path: "fields.trim_key",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.trim_value,
    path: "fields.trim_value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ToggleField,
    config: fieldsConfig.strip_brackets,
    path: "fields.strip_brackets",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }));
};
exports.Kv = Kv;