"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Circle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/circle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const {
  toInt
} = _shared_imports.fieldFormatters;
const fieldsConfig = {
  /* Required fields config */
  error_distance: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    formatters: [toInt],
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceFieldLabel', {
      defaultMessage: 'Error distance'
    }),
    helpText: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceHelpText",
      defaultMessage: "Difference between the side of the inscribed shape to the encompassing circle. Determines the accuracy of the output polygon. Measured in meters for {geo_shape}, but uses no units for {shape}.",
      values: {
        geo_shape: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 22
          }
        }, 'geo_shape'),
        shape: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 18
          }
        }, 'shape')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.errorDistanceError', {
        defaultMessage: 'An error distance value is required.'
      }))
    }]
  },
  shape_type: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    serializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeFieldLabel', {
      defaultMessage: 'Shape type'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeFieldHelpText', {
      defaultMessage: 'Field mapping type to use when processing the output polygon.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeRequiredError', {
        defaultMessage: 'A shape type value is required.'
      }))
    }]
  }
};
const Circle = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.fieldNameHelpText', {
      defaultMessage: 'Field to convert.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "errorDistanceField",
    config: fieldsConfig.error_distance,
    component: _shared_imports.NumericField,
    path: "fields.error_distance",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'shapeSelectorField',
        options: [{
          value: 'shape',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeShape', {
            defaultMessage: 'Shape'
          })
        }, {
          value: 'geo_shape',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.circleForm.shapeTypeGeoShape', {
            defaultMessage: 'Geo-shape'
          })
        }]
      }
    },
    config: fieldsConfig.shape_type,
    component: _shared_imports.SelectField,
    path: "fields.shape_type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }));
};
exports.Circle = Circle;