"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveySection = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _use_kibana = require("../../../../hooks/use_kibana");
var _survey_kubernetes = require("./survey_kubernetes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/survey_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INVENTORY_FEEDBACK_LINK = 'https://ela.st/survey-infra-inventory';
const SurveySection = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search.includes('nodeType:pod') ? /*#__PURE__*/_react.default.createElement(_survey_kubernetes.SurveyKubernetes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    "data-test-subj": "infraInventoryFeedbackLink",
    formUrl: INVENTORY_FEEDBACK_LINK,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    sanitizedPath: document.location.pathname,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }));
};
exports.SurveySection = SurveySection;