"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfrastructurePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _help_center_content = require("../../components/help_center_content");
var _use_readonly_badge = require("../../hooks/use_readonly_badge");
var _settings = require("./settings");
var _metrics_alert_dropdown = require("../../alerting/common/components/metrics_alert_dropdown");
var _use_alert_prefill = require("../../alerting/use_alert_prefill");
var _infra_ml_capabilities = require("../../containers/ml/infra_ml_capabilities");
var _anomaly_detection_flyout = require("../../components/ml/anomaly_detection/anomaly_detection_flyout");
var _header_action_menu_provider = require("../../containers/header_action_menu_provider");
var _ = require("../404");
var _react_query_provider = require("../../containers/react_query_provider");
var _plugin_config_context = require("../../containers/plugin_config_context");
var _redirect_with_query_params = require("../../utils/redirect_with_query_params");
var _use_reload_request_time = require("../../hooks/use_reload_request_time");
var _no_data_config = require("../../components/shared/templates/no_data_config");
var _survey_section = require("./inventory_view/components/survey_section");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.infra.metricsHeaderAddDataButtonLabel', {
  defaultMessage: 'Add data'
});
const HOSTS_FEEDBACK_LINK = 'https://ela.st/host-feedback';
const METRICS_EXPLORER_FEEDBACK_URL = 'https://ela.st/survey-infra-metricsexplorer';
const MetricsExplorerPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./metrics_explorer'))).then(mod => ({
  default: mod.MetricsExplorerPage
})));
const SnapshotPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./inventory_view'))).then(mod => ({
  default: mod.SnapshotPage
})));
const NodeDetail = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./metric_detail'))).then(mod => ({
  default: mod.NodeDetail
})));
const HostsPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./hosts'))).then(mod => ({
  default: mod.HostsPage
})));
const InfrastructurePage = () => {
  var _uiCapabilities$infra;
  const config = (0, _plugin_config_context.usePluginConfig)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_provider.HeaderActionMenuContext);
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  const settingsTabTitle = _i18n.i18n.translate('xpack.infra.metrics.settingsTabTitle', {
    defaultMessage: 'Settings'
  });
  (0, _use_readonly_badge.useReadOnlyBadge)(!(uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$infra = uiCapabilities.infrastructure) !== null && _uiCapabilities$infra !== void 0 && _uiCapabilities$infra.save));
  const settingsLinkProps = (0, _public2.useLinkProps)({
    app: 'metrics',
    pathname: 'settings'
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react_query_provider.ReactQueryProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_alert_prefill.AlertPrefillProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_reload_request_time.ReloadRequestTimeProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_infra_ml_capabilities.InfraMLCapabilitiesProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_help_center_content.HelpCenterContent, {
    feedbackLink: "https://discuss.elastic.co/c/metrics",
    appName: _i18n.i18n.translate('xpack.infra.header.infrastructureHelpAppName', {
      defaultMessage: 'Metrics'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }), setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(HeaderLinkFeedbackButtonRoute, {
    path: "/inventory",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkFeedbackButtonRoute, {
    path: "/explorer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkFeedbackButtonRoute, {
    path: "/hosts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/inventory",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/hosts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/detail/host/:node",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 27
    }
  })), config.featureFlags.alertsAndRulesDropdownEnabled && /*#__PURE__*/_react.default.createElement(_metrics_alert_dropdown.MetricsAlertDropdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    color: 'primary'
  }, settingsLinkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 25
    }
  }), settingsTabTitle), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/hosts",
    onboardingFlow: _no_data_config.OnboardingFlow.Hosts,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/detail/host/:node",
    onboardingFlow: _no_data_config.OnboardingFlow.Hosts,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/",
    onboardingFlow: _no_data_config.OnboardingFlow.Infra,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 27
    }
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    enableExecutionContextTracking: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/inventory",
    component: SnapshotPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }), config.featureFlags.metricsExplorerEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/explorer",
    component: MetricsExplorerPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/detail/:type/:node",
    component: NodeDetail,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/hosts",
    component: HostsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/settings",
    component: _settings.MetricsSettingsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/snapshot",
    exact: true,
    to: "/inventory",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/metrics-explorer",
    exact: true,
    to: "/explorer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/",
    exact: true,
    to: "/inventory",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      title: _i18n.i18n.translate('xpack.infra.header.infrastructureLabel', {
        defaultMessage: 'Infrastructure'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  })))))));
};
exports.InfrastructurePage = InfrastructurePage;
const HeaderLinkAnomalyFlyoutRoute = ({
  path
}) => {
  const isInventory = path !== '/inventory';
  const {
    isTopbarMenuVisible
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    render: () => isTopbarMenuVisible ? /*#__PURE__*/_react.default.createElement(_anomaly_detection_flyout.AnomalyDetectionFlyout, {
      hideJobType: isInventory,
      hideSelectGroup: isInventory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  });
};
const HeaderLinkAddDataRoute = ({
  path,
  onboardingFlow,
  exact
}) => {
  const {
    share
  } = (0, _public.useKibana)().services;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    exact: exact,
    render: () => /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({
        category: onboardingFlow === _no_data_config.OnboardingFlow.Hosts ? 'host' : undefined
      }),
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    }, ADD_DATA_LABEL),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  });
};
const feedbackLinksPathMap = {
  '/hosts': {
    formUrl: HOSTS_FEEDBACK_LINK,
    dts: 'infraHostsPageTellUsWhatYouThinkButton'
  },
  '/explorer': {
    formUrl: METRICS_EXPLORER_FEEDBACK_URL,
    dts: 'infraMetricsExplorerFeedbackLink'
  }
};
const HeaderLinkFeedbackButtonRoute = ({
  path,
  exact
}) => {
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  if (path === '/inventory') {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      path: path,
      exact: exact,
      render: () => /*#__PURE__*/_react.default.createElement(_survey_section.SurveySection, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 59
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    exact: exact,
    render: () => {
      var _feedbackLinksPathMap, _feedbackLinksPathMap2, _feedbackLinksPathMap3;
      return /*#__PURE__*/_react.default.createElement(_public2.FeatureFeedbackButton, {
        "data-test-subj": (_feedbackLinksPathMap = (_feedbackLinksPathMap2 = feedbackLinksPathMap[path]) === null || _feedbackLinksPathMap2 === void 0 ? void 0 : _feedbackLinksPathMap2.dts) !== null && _feedbackLinksPathMap !== void 0 ? _feedbackLinksPathMap : 'infraInventoryFeedbackLink',
        formUrl: (_feedbackLinksPathMap3 = feedbackLinksPathMap[path]) === null || _feedbackLinksPathMap3 === void 0 ? void 0 : _feedbackLinksPathMap3.formUrl,
        kibanaVersion: kibanaVersion,
        isCloudEnv: isCloudEnv,
        isServerlessEnv: isServerlessEnv,
        sanitizedPath: path,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 9
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 5
    }
  });
};