"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../../hooks/use_kibana");
var _metadata_summary_list = require("./metadata_summary/metadata_summary_list");
var _alerts = require("./alerts/alerts");
var _kpi_grid = require("./kpis/kpi_grid");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _use_data_views = require("../../hooks/use_data_views");
var _use_date_picker = require("../../hooks/use_date_picker");
var _metadata_error_callout = require("../../components/metadata_error_callout");
var _cpu_profiling_prompt = require("./kpis/cpu_profiling_prompt");
var _services = require("./services");
var _metrics = require("./metrics/metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Overview = () => {
  var _application$capabili;
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    entity,
    renderMode,
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading,
    error: fetchMetadataError
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    metrics
  } = (0, _use_data_views.useDataViewsContext)();
  const isFullPageView = renderMode.mode === 'page';
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const hasApmPermissions = Boolean((_application$capabili = application.capabilities.apm) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show);
  const metadataSummarySection = isFullPageView ? /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryList, {
    metadata: metadata,
    loading: metadataLoading,
    entityType: entity.type,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_metadata_summary_list.MetadataSummaryListCompact, {
    metadata: metadata,
    loading: metadataLoading,
    entityType: entity.type,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_kpi_grid.KPIGrid, {
    entityId: entity.id,
    entityType: entity.type,
    dateRange: dateRange,
    dataView: metrics.dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), entity.type === 'host' ? /*#__PURE__*/_react.default.createElement(_cpu_profiling_prompt.CpuProfilingPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 35
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, fetchMetadataError && !metadataLoading ? /*#__PURE__*/_react.default.createElement(_metadata_error_callout.MetadataErrorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 51
    }
  }) : metadataSummarySection, /*#__PURE__*/_react.default.createElement(SectionSeparator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })), entity.type === 'host' || entity.type === 'container' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts.AlertsSummaryContent, {
    entityId: entity.id,
    entityType: entity.type,
    dateRange: dateRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(SectionSeparator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })) : null, entity.type === 'host' && hasApmPermissions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_services.ServicesContent, {
    hostName: entity.id,
    dateRange: dateRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(SectionSeparator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics.MetricsContent, {
    entityId: entity.id,
    entityType: entity.type,
    dateRange: dateRange,
    dataView: metrics.dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  })));
};
exports.Overview = Overview;
const SectionSeparator = () => /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "m",
  css: (0, _react2.css)`
      margin-bottom: 0;
    `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 3
  }
});