"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metrics/metrics_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsTemplate = exports.MetricsTemplate = /*#__PURE__*/_react.default.forwardRef(({
  children
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    renderMode
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    scrollTo,
    setScrollTo
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const scrollTimeoutRef = (0, _react.useRef)(null);
  const initialScrollTimeoutRef = (0, _react.useRef)(null);
  const quickAccessItemsRef = (0, _react.useRef)(new Map());
  const contentRefs = (0, _react.useRef)({});
  const quickAccessRef = (0, _react.useRef)(null);
  const isLargeScreen = (0, _eui.useIsWithinBreakpoints)(['xl'], true);
  const listGroupDimensions = (0, _eui.useResizeObserver)(quickAccessRef.current);
  const kibanaHeaderOffset = renderMode.mode === 'flyout' ? `0px` : `var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0))`;
  const quickAccessHorizontalOffset = isLargeScreen ? `${euiTheme.size.s} - 1px` // arbitrary value to align with the content
  : `${listGroupDimensions.height}px`;
  const quickAccessOffset = `calc(${kibanaHeaderOffset} + ${quickAccessHorizontalOffset})`;
  const setContentRef = (0, _react.useCallback)(contentRef => {
    const sectionId = contentRef === null || contentRef === void 0 ? void 0 : contentRef.getAttribute('data-section-id');
    const label = contentRef === null || contentRef === void 0 ? void 0 : contentRef.innerText;
    if (!sectionId) {
      return;
    }
    contentRefs.current[sectionId] = contentRef;
    if (!quickAccessItemsRef.current.has(sectionId)) {
      quickAccessItemsRef.current.set(sectionId, label);
    }
  }, []);
  const scrollToSection = (0, _react.useCallback)((sectionId, retries = 5, delay = 300) => {
    var _contentRefs$current$, _contentRefs$current$2;
    const chartEl = (_contentRefs$current$ = (_contentRefs$current$2 = contentRefs.current[sectionId]) === null || _contentRefs$current$2 === void 0 ? void 0 : _contentRefs$current$2.querySelectorAll('.euiPanel')) !== null && _contentRefs$current$ !== void 0 ? _contentRefs$current$ : [];
    if (chartEl.length > 0) {
      var _contentRefs$current$3;
      (_contentRefs$current$3 = contentRefs.current[sectionId]) === null || _contentRefs$current$3 === void 0 ? void 0 : _contentRefs$current$3.scrollIntoView({
        behavior: 'smooth',
        block: 'start'
      });
    } else if (retries > 0) {
      // Retry scrolling after a delay - needed for conditionally rendered content
      const nextDelay = delay * 2;
      scrollTimeoutRef.current = setTimeout(() => scrollToSection(sectionId, retries - 1), nextDelay);
    }
  }, []);
  const onQuickAccessItemClick = metric => {
    if (metric !== scrollTo) {
      setScrollTo(metric);
    } else {
      scrollToSection(metric);
    }
  };
  (0, _react.useEffect)(() => {
    if (scrollTo) {
      // Wait for the calculation of quickAccessOffset
      initialScrollTimeoutRef.current = setTimeout(() => scrollToSection(scrollTo), 100);
    }
  }, [scrollTo, scrollToSection]);
  (0, _react.useEffect)(() => () => {
    [scrollTimeoutRef.current, initialScrollTimeoutRef.current].filter(timeout => !!timeout).forEach(timeout => clearTimeout(timeout));
  }, []);
  const quickAccessItems = [...quickAccessItemsRef.current];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    css: (0, _css.css)`
          ${(0, _eui.useEuiMaxBreakpoint)('xl')} {
            flex-direction: column;
          }
        `,
    "data-test-subj": "infraAssetDetailsMetricChartsContent",
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _css.css)`
            position: sticky;
            top: ${kibanaHeaderOffset};
            background: ${euiTheme.colors.emptyShade};
            min-width: 100px;
            z-index: ${euiTheme.levels.navigation};
            ${(0, _eui.useEuiMinBreakpoint)('xl')} {
              align-self: flex-start;
            }
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: quickAccessRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    css: (0, _css.css)`
                ${(0, _eui.useEuiMaxBreakpoint)('xl')} {
                  flex-direction: row;
                  flex-wrap: wrap;
                  gap: 0px ${euiTheme.size.xl};
                  min-width: 100%;
                  border-bottom: ${euiTheme.border.thin};
                }
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, quickAccessItems.map(([sectionId, label]) => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": `infraMetricsQuickAccessItem${sectionId}`,
    key: sectionId,
    onClick: () => onQuickAccessItemClick(sectionId),
    color: "text",
    size: "s",
    className: (0, _css.cx)({
      [(0, _css.css)`
                      text-decoration: underline;
                    `]: sectionId === scrollTo
    }),
    css: (0, _css.css)`
                    background-color: unset;
                    & > button {
                      padding-block: ${euiTheme.size.s};
                      padding-inline: 0px;
                    }
                    &:hover,
                    &:focus-within {
                      background-color: unset;
                    }
                  `,
    label: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    css: (0, _css.css)`
              padding-top: ${euiTheme.size.s};
              & > [data-section-id] {
                scroll-margin-top: ${quickAccessOffset};
              }
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, _react.default.Children.map(children, (child, index) => {
    if (/*#__PURE__*/_react.default.isValidElement(child)) {
      return /*#__PURE__*/_react.default.cloneElement(child, {
        ref: setContentRef,
        key: index
      });
    }
  }))));
});