"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_data_views = require("../../hooks/use_data_views");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _metrics_template = require("./metrics_template");
var _charts = require("../../charts");
var _constants = require("../../constants");
var _use_integration_check = require("../../hooks/use_integration_check");
var _add_metrics_callout = require("../../add_metrics_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metrics/container_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContainerMetrics = () => {
  const ref = (0, _react.useRef)(null);
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metrics
  } = (0, _use_data_views.useDataViewsContext)();
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    dateRange
  });
  const isDockerContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.docker
  });
  const isKubernetesContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.kubernetesContainer
  });
  if (!isDockerContainer && !isKubernetesContainer) {
    return /*#__PURE__*/_react.default.createElement(_add_metrics_callout.AddMetricsCallout, {
      id: "containerMetrics",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_metrics_template.MetricsTemplate, {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, isDockerContainer && _constants.DOCKER_METRIC_TYPES.map(metric => /*#__PURE__*/_react.default.createElement(_charts.DockerCharts, {
    key: metric,
    entityId: entity.id,
    dataView: metrics.dataView,
    dateRange: state.dateRange,
    metric: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  })), !isDockerContainer && isKubernetesContainer && _constants.KUBERNETES_METRIC_TYPES.map(metric => /*#__PURE__*/_react.default.createElement(_charts.KubernetesContainerCharts, {
    key: metric,
    entityId: entity.id,
    dataView: metrics.dataView,
    dateRange: state.dateRange,
    metric: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  })));
};
exports.ContainerMetrics = ContainerMetrics;