"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/logs-shared-plugin/common");
var _common2 = require("@kbn/metrics-data-access-plugin/common");
var _public = require("@kbn/logs-shared-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _react2 = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/logs/logs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEXT_QUERY_THROTTLE_INTERVAL_MS = 500;
const Logs = () => {
  var _urlState$logsSearch, _urlState$logsSearch2;
  const ref = (0, _react.useRef)(null);
  const {
    getDateRangeInTimestamp,
    dateRange,
    autoRefresh
  } = (0, _use_date_picker.useDatePickerContext)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    services: {
      logsDataAccess: {
        services: {
          logSourcesService
        }
      },
      embeddable,
      dataViews,
      data: {
        search: {
          searchSource
        }
      },
      share: {
        url
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(url);
  const [textQuery, setTextQuery] = (0, _react.useState)((_urlState$logsSearch = urlState === null || urlState === void 0 ? void 0 : urlState.logsSearch) !== null && _urlState$logsSearch !== void 0 ? _urlState$logsSearch : '');
  const [textQueryDebounced, setTextQueryDebounced] = (0, _react.useState)((_urlState$logsSearch2 = urlState === null || urlState === void 0 ? void 0 : urlState.logsSearch) !== null && _urlState$logsSearch2 !== void 0 ? _urlState$logsSearch2 : '');
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const currentTimestamp = getDateRangeInTimestamp().to;
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    currentTimestamp,
    startTimestamp: currentTimestamp - 60 * 60 * 1000,
    dateRange,
    autoRefresh
  });
  (0, _useDebounce.default)(() => {
    setUrlState({
      logsSearch: textQuery
    });
    setTextQueryDebounced(textQuery);
  }, TEXT_QUERY_THROTTLE_INTERVAL_MS, [textQuery]);

  // Entity context filter - should NOT be highlighted
  const entityContextFilter = (0, _react.useMemo)(() => [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(`${(0, _common2.findInventoryFields)(entity.type).id}: "${entity.id}"`))], [entity.type, entity.id]);

  // User search filter - should be highlighted
  const userSearchFilter = (0, _react.useMemo)(() => {
    if (!textQueryDebounced || textQueryDebounced.trim() === '') {
      return [];
    }
    try {
      return [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(textQueryDebounced))];
    } catch (err) {
      // Invalid/incomplete query, return empty array to avoid breaking the component
      return [];
    }
  }, [textQueryDebounced]);

  // User search filters - WILL be highlighted
  const documentFilters = (0, _react.useMemo)(() => {
    // Exit early if no log sources
    if (!logSources.value) {
      return [];
    }

    // Add user search filter (enable highlighting)
    if (userSearchFilter.length > 0) {
      return [(0, _esQuery.buildCustomFilter)(logSources.value, userSearchFilter[0], false, false, 'User Search', _esQuery.FilterStateStore.APP_STATE)];
    }
    return [];
  }, [userSearchFilter, logSources.value]);

  // Entity context filters - WON'T be highlighted
  const nonHighlightingFilters = (0, _react.useMemo)(() => {
    // Exit early if no log sources
    if (!logSources.value) {
      return [];
    }

    // Add entity context filter (skip highlighting)
    if (entityContextFilter.length > 0) {
      return [(0, _esQuery.buildCustomFilter)(logSources.value, entityContextFilter[0], false, false, 'Entity Context', _esQuery.FilterStateStore.APP_STATE)];
    }
    return [];
  }, [entityContextFilter, logSources.value]);
  const onQueryChange = (0, _react.useCallback)(e => {
    setTextQuery(e.target.value);
  }, []);
  const logsUrl = (0, _react.useMemo)(() => {
    return logsLocator.getRedirectUrl({
      query: (0, _common.getNodeQuery)({
        nodeField: (0, _common2.findInventoryFields)(entity.type).id,
        nodeId: entity.id,
        filter: textQueryDebounced
      }),
      timeRange: {
        from: (0, _moment.default)(state.startTimestamp).toISOString(),
        to: (0, _moment.default)(state.currentTimestamp).toISOString()
      }
    });
  }, [logsLocator, entity.type, entity.id, textQueryDebounced, state.startTimestamp, state.currentTimestamp]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: (0, _react2.css)`
          .DiscoverFlyout {
            z-index: 6000 !important;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraAssetDetailsLogsTabFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.nodeDetails.logs.textFieldPlaceholder', {
      defaultMessage: 'Search for log entries...'
    }),
    value: textQuery,
    isClearable: true,
    onChange: onQueryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_public.OpenInLogsExplorerButton, {
    href: logsUrl,
    testSubject: 'infraAssetDetailsLogsTabOpenInLogsButton',
    size: "xs",
    flush: "both",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, logSources.value ? /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: dateRange,
    filters: documentFilters,
    nonHighlightingFilters: nonHighlightingFilters,
    height: "68vh",
    displayOptions: {
      solutionNavIdOverride: 'oblt',
      enableFilters: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }) : null)));
};
exports.Logs = Logs;