"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useK8sContainerPageViewMetricsCharts = exports.useK8sContainerKpiCharts = exports.useDockerContainerPageViewMetricsCharts = exports.useDockerContainerKpiCharts = exports.getSubtitleFromFormula = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _constants = require("../constants");
var _use_chart_series_color = require("./use_chart_series_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubtitleFromFormula = value => {
  // Check if 'avg' or 'average' is the first word/function in the formula
  if (_constants.AVG_OR_AVERAGE_AS_FIRST_FUNCTION_PATTERN.test(value)) {
    return _i18n.i18n.translate('xpack.infra.assetDetails.kpi.subtitle.average', {
      defaultMessage: 'Average'
    });
  }

  // Check if 'max' is the first word/function in the formula
  if (_constants.MAX_AS_FIRST_FUNCTION_PATTERN.test(value)) {
    return _i18n.i18n.translate('xpack.infra.containerViewPage.kpi.subtitle.max', {
      defaultMessage: 'Max'
    });
  }

  // remove the fallback subtitle to avoid confusion
  return '';
};
exports.getSubtitleFromFormula = getSubtitleFromFormula;
const useDockerContainerPageViewMetricsCharts = ({
  metric,
  metricsDataViewId
}) => {
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const containerCharts = await getDockerContainerCharts(metric);
    return containerCharts.map(chart => {
      return {
        ...chart,
        ...(metricsDataViewId && {
          dataset: {
            index: metricsDataViewId
          }
        })
      };
    });
  }, [metricsDataViewId, metric]);
  return {
    charts,
    error
  };
};
exports.useDockerContainerPageViewMetricsCharts = useDockerContainerPageViewMetricsCharts;
const getDockerContainerCharts = async metric => {
  const model = (0, _common.findInventoryModel)('container');
  const {
    cpu,
    memory,
    network,
    diskIO
  } = await model.metrics.getCharts();
  switch (metric) {
    case 'cpu':
      return [cpu.xy.dockerContainerCpuUsage];
    case 'memory':
      return [memory.xy.dockerContainerMemoryUsage];
    case 'network':
      return [network.xy.dockerContainerRxTx];
    case 'disk':
      return [diskIO.xy.dockerContainerDiskIOReadWrite];
    default:
      return [];
  }
};
const useK8sContainerPageViewMetricsCharts = ({
  metric,
  metricsDataViewId
}) => {
  const {
    value: charts = [],
    error
  } = (0, _useAsync.default)(async () => {
    const containerK8sCharts = await getK8sContainerCharts(metric);
    return containerK8sCharts.map(chart => {
      return {
        ...chart,
        ...(metricsDataViewId && {
          dataset: {
            index: metricsDataViewId
          }
        })
      };
    });
  }, [metricsDataViewId, metric]);
  return {
    charts,
    error
  };
};
exports.useK8sContainerPageViewMetricsCharts = useK8sContainerPageViewMetricsCharts;
const getK8sContainerCharts = async metric => {
  const model = (0, _common.findInventoryModel)('container');
  const {
    cpu,
    memory
  } = await model.metrics.getCharts();
  switch (metric) {
    case 'cpu':
      return [cpu.xy.k8sContainerCpuUsage];
    case 'memory':
      return [memory.xy.k8sContainerMemoryUsage];
    default:
      return [];
  }
};
const useDockerContainerKpiCharts = ({
  dataViewId,
  seriesColor
}) => {
  seriesColor = (0, _use_chart_series_color.useChartSeriesColor)(seriesColor);
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('container');
    const {
      cpu,
      memory
    } = await model.metrics.getCharts();
    return [cpu.metric.dockerContainerCpuUsage, memory.metric.dockerContainerMemoryUsage].map(chart => ({
      ...chart,
      seriesColor,
      decimals: 1,
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId, seriesColor]);
  return charts;
};
exports.useDockerContainerKpiCharts = useDockerContainerKpiCharts;
const useK8sContainerKpiCharts = ({
  dataViewId,
  seriesColor
}) => {
  seriesColor = (0, _use_chart_series_color.useChartSeriesColor)(seriesColor);
  const {
    value: charts = []
  } = (0, _useAsync.default)(async () => {
    const model = (0, _common.findInventoryModel)('container');
    const {
      cpu,
      memory
    } = await model.metrics.getCharts();
    return [cpu.metric.k8sContainerCpuUsage, memory.metric.k8sContainerMemoryUsage].map(chart => ({
      ...chart,
      seriesColor,
      decimals: 1,
      subtitle: getSubtitle(chart),
      ...(dataViewId && {
        dataset: {
          index: dataViewId
        }
      })
    }));
  }, [dataViewId, seriesColor]);
  return charts;
};
exports.useK8sContainerKpiCharts = useK8sContainerKpiCharts;
function getSubtitle(chart) {
  return getSubtitleFromFormula(chart.value);
}