"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessesExplanationMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_date_picker = require("../hooks/use_date_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/processes_explanation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessesExplanationMessage = () => {
  const {
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const dateFromRange = new Date(getDateRangeInTimestamp().to);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.overview.processesSectionTitle",
    defaultMessage: "Showing process data collected for the 1 minute preceding {date} @ {time}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: dateFromRange,
        month: "short",
        day: "numeric",
        year: "numeric",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 17
        }
      }),
      time: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: dateFromRange,
        hour12: false,
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 13
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }));
};
exports.ProcessesExplanationMessage = ProcessesExplanationMessage;