"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAlertDropdown = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _create_focus_trap_props = require("../../../utils/create_focus_trap_props");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _alert_flyout = require("../../inventory/components/alert_flyout");
var _alert_flyout2 = require("../../metric_threshold/components/alert_flyout");
var _custom_threshold = require("../../custom_threshold");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/common/components/metrics_alert_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useInfrastructureMenu(onCreateRuleClick) {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  return (0, _react.useMemo)(() => {
    if (!featureFlags.inventoryThresholdAlertRuleEnabled) {
      return {
        items: [],
        panels: []
      };
    }
    return {
      items: [{
        'data-test-subj': 'inventory-alerts-menu-option',
        name: _i18n.i18n.translate('xpack.infra.alerting.infrastructureDropdownMenu', {
          defaultMessage: 'Infrastructure'
        }),
        panel: 1
      }],
      panels: [{
        id: 1,
        title: _i18n.i18n.translate('xpack.infra.alerting.infrastructureDropdownTitle', {
          defaultMessage: 'Infrastructure rules'
        }),
        items: [{
          'data-test-subj': 'inventory-alerts-create-rule',
          name: _i18n.i18n.translate('xpack.infra.alerting.createInventoryRuleButton', {
            defaultMessage: 'Create inventory rule'
          }),
          onClick: () => onCreateRuleClick('inventory')
        }]
      }]
    };
  }, [featureFlags.inventoryThresholdAlertRuleEnabled, onCreateRuleClick]);
}
function useMetricsMenu(onCreateRuleClick) {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  return (0, _react.useMemo)(() => {
    if (!featureFlags.metricThresholdAlertRuleEnabled) {
      return {
        items: [],
        panels: []
      };
    }
    return {
      items: [{
        'data-test-subj': 'metrics-threshold-alerts-menu-option',
        name: _i18n.i18n.translate('xpack.infra.alerting.metricsDropdownMenu', {
          defaultMessage: 'Metrics'
        }),
        panel: 2
      }],
      panels: [{
        id: 2,
        title: _i18n.i18n.translate('xpack.infra.alerting.metricsDropdownTitle', {
          defaultMessage: 'Metrics rules'
        }),
        items: [{
          'data-test-subj': 'metrics-threshold-alerts-create-rule',
          name: _i18n.i18n.translate('xpack.infra.alerting.createThresholdRuleButton', {
            defaultMessage: 'Create threshold rule'
          }),
          onClick: () => onCreateRuleClick('metricThreshold')
        }]
      }]
    };
  }, [featureFlags.metricThresholdAlertRuleEnabled, onCreateRuleClick]);
}
function useCustomThresholdMenu(onCreateRuleClick) {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  return (0, _react.useMemo)(() => {
    if (!featureFlags.customThresholdAlertsEnabled) {
      return {
        items: [],
        panels: []
      };
    }
    return {
      items: [{
        'data-test-subj': 'custom-threshold-alerts-menu-option',
        name: _i18n.i18n.translate('xpack.infra.alerting.customThresholdDropdownMenu', {
          defaultMessage: 'Create custom threshold rule'
        }),
        onClick: () => onCreateRuleClick('customThreshold')
      }],
      panels: []
    };
  }, [featureFlags.customThresholdAlertsEnabled, onCreateRuleClick]);
}
const MetricsAlertDropdown = () => {
  var _useKibana$services$a;
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [visibleFlyoutType, setVisibleFlyoutType] = (0, _react.useState)(null);
  const alertsButtonRef = (0, _react.useRef)(null);
  const uiCapabilities = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const {
    services: {
      observability
    }
  } = (0, _public.useKibana)();
  const canCreateAlerts = (0, _react.useMemo)(() => {
    var _uiCapabilities$infra;
    return Boolean(uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.save);
  }, [uiCapabilities]);
  const closeFlyout = (0, _react.useCallback)(() => setVisibleFlyoutType(null), [setVisibleFlyoutType]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(false);
  }, [setPopoverOpen]);
  const togglePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(!popoverOpen);
  }, [setPopoverOpen, popoverOpen]);
  const onCreateRuleClick = (0, _react.useCallback)(flyoutType => {
    closePopover();
    setVisibleFlyoutType(flyoutType);
  }, [closePopover]);
  const infrastructureMenu = useInfrastructureMenu(onCreateRuleClick);
  const metricsMenu = useMetricsMenu(onCreateRuleClick);
  const customThresholdMenu = useCustomThresholdMenu(onCreateRuleClick);
  const manageRulesLinkProps = observability.useRulesLink();
  const focusTrapProps = (0, _create_focus_trap_props.createFocusTrapProps)(alertsButtonRef.current);
  const manageAlertsMenuItem = (0, _react.useMemo)(() => ({
    name: _i18n.i18n.translate('xpack.infra.alerting.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    icon: 'tableOfContents',
    onClick: manageRulesLinkProps.onClick
  }), [manageRulesLinkProps]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: _i18n.i18n.translate('xpack.infra.alerting.alertDropdownTitle', {
      defaultMessage: 'Alerts and rules'
    }),
    items: canCreateAlerts ? [...infrastructureMenu.items, ...metricsMenu.items, ...customThresholdMenu.items, manageAlertsMenuItem] : [manageAlertsMenuItem]
  }, ...(canCreateAlerts ? [...infrastructureMenu.panels, ...metricsMenu.panels, ...customThresholdMenu.panels] : [])], [canCreateAlerts, infrastructureMenu, metricsMenu, customThresholdMenu, manageAlertsMenuItem]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      buttonRef: alertsButtonRef,
      color: "primary",
      iconSide: 'right',
      iconType: 'arrowDown',
      onClick: togglePopover,
      "data-test-subj": "infrastructure-alerts-and-rules",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.alerting.alertsButton",
      defaultMessage: "Alerts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 13
      }
    })),
    isOpen: popoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "metrics-alert-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(AlertFlyout, {
    visibleFlyoutType: visibleFlyoutType,
    onClose: closeFlyout,
    focusTrapProps: focusTrapProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }));
};
exports.MetricsAlertDropdown = MetricsAlertDropdown;
const AlertFlyout = ({
  visibleFlyoutType,
  onClose,
  focusTrapProps
}) => {
  switch (visibleFlyoutType) {
    case 'inventory':
      return /*#__PURE__*/_react.default.createElement(_alert_flyout.PrefilledInventoryAlertFlyout, {
        onClose: onClose,
        focusTrapProps: focusTrapProps,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 14
        }
      });
    case 'metricThreshold':
      return /*#__PURE__*/_react.default.createElement(_alert_flyout2.PrefilledMetricThresholdAlertFlyout, {
        onClose: onClose,
        focusTrapProps: focusTrapProps,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 9
        }
      });
    case 'customThreshold':
      return /*#__PURE__*/_react.default.createElement(_custom_threshold.AlertFlyout, {
        onClose: onClose,
        focusTrapProps: focusTrapProps,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 14
        }
      });
    default:
      return null;
  }
};