"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mustUseThoughtSignature = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the specified model must provide thought signatures for
 */
const mustUseThoughtSignature = modelName => {
  // if we couldn't resolve the model name, we can't know if it must use thought signatures
  if (modelName === undefined) {
    return false;
  }
  return isGemini3Pro(modelName);
};
exports.mustUseThoughtSignature = mustUseThoughtSignature;
const isGemini3Pro = modelName => modelName.toLowerCase().includes('gemini-3-pro');