"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeEnrichmentPolicies = exports.enrichPoliciesActions = void 0;
var _lib = require("../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serializeEnrichmentPolicies = policies => {
  return policies.map(policy => {
    const policyType = (0, _lib.getPolicyType)(policy);
    return {
      name: policy.config[policyType].name,
      type: policyType,
      sourceIndices: policy.config[policyType].indices,
      matchField: policy.config[policyType].match_field,
      enrichFields: policy.config[policyType].enrich_fields,
      query: policy.config[policyType].query
    };
  });
};
exports.serializeEnrichmentPolicies = serializeEnrichmentPolicies;
const fetchAll = async client => {
  const res = await client.asCurrentUser.enrich.getPolicy();
  return serializeEnrichmentPolicies(res.policies);
};
const create = (client, policyName, serializedPolicy) => {
  return client.asCurrentUser.enrich.putPolicy({
    name: policyName,
    ...serializedPolicy
  });
};
const execute = (client, policyName) => {
  // Enrich policy executions can last as short as a few seconds to as long as half and hour or longer.
  // In order to prevent the enrich policies UI from timing out, we are disabling `waitForCompletion`.
  return client.asCurrentUser.enrich.executePolicy({
    name: policyName,
    wait_for_completion: false
  });
};
const remove = (client, policyName) => {
  return client.asCurrentUser.enrich.deletePolicy({
    name: policyName
  });
};
const enrichPoliciesActions = exports.enrichPoliciesActions = {
  fetchAll,
  create,
  execute,
  remove
};