"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureFailureStoreModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _failureStoreModal = require("@kbn/failure-store-modal");
var _app_context = require("../../../../app_context");
var _api = require("../../../../services/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/configure_failure_store_modal/configure_failure_store_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigureFailureStoreModal = ({
  dataStreams,
  onClose
}) => {
  var _dataStream$failureSt, _dataStream$failureSt2, _dataStream$failureSt3, _dataStream$failureSt4, _dataStream$failureSt5;
  // We will support multiple data streams in the future, but for now we only support one.
  const dataStream = dataStreams[0];
  const {
    services: {
      notificationService
    },
    config: {
      enableFailureStoreRetentionDisabling
    }
  } = (0, _app_context.useAppContext)();
  const handleSaveModal = async data => {
    return (0, _api.updateDSFailureStore)([dataStream.name], {
      dsFailureStore: data.failureStoreEnabled,
      customRetentionPeriod: 'customRetentionPeriod' in data && data.customRetentionPeriod ? data.customRetentionPeriod : undefined,
      retentionDisabled: 'retentionDisabled' in data && data.retentionDisabled
    }).then(({
      data: responseData,
      error
    }) => {
      if (responseData) {
        if (responseData.warning) {
          notificationService.showWarningToast(responseData.warning);
          return onClose({
            hasUpdatedFailureStore: true
          });
        }
        const successMessage = _i18n.i18n.translate('xpack.idxMgmt.dataStreams.configureFailureStoreModal.successFailureStoreNotification', {
          defaultMessage: 'Failure store {disabledFailureStore, plural, one { disabled } other { enabled } }',
          values: {
            disabledFailureStore: !data.failureStoreEnabled ? 1 : 0
          }
        });
        notificationService.showSuccessToast(successMessage);
        return onClose({
          hasUpdatedFailureStore: true
        });
      }
      if (error) {
        const errorMessage = _i18n.i18n.translate('xpack.idxMgmt.dataStreams.configureFailureStoreModal.errorFailureStoreNotification', {
          defaultMessage: "Error configuring failure store: ''{error}''",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      onClose();
    });
  };
  return /*#__PURE__*/_react.default.createElement(_failureStoreModal.FailureStoreModal, {
    onCloseModal: onClose,
    onSaveModal: handleSaveModal,
    failureStoreProps: {
      failureStoreEnabled: (_dataStream$failureSt = dataStream === null || dataStream === void 0 ? void 0 : dataStream.failureStoreEnabled) !== null && _dataStream$failureSt !== void 0 ? _dataStream$failureSt : false,
      customRetentionPeriod: dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$failureSt2 = dataStream.failureStoreRetention) === null || _dataStream$failureSt2 === void 0 ? void 0 : _dataStream$failureSt2.customRetentionPeriod,
      defaultRetentionPeriod: dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$failureSt3 = dataStream.failureStoreRetention) === null || _dataStream$failureSt3 === void 0 ? void 0 : _dataStream$failureSt3.defaultRetentionPeriod,
      retentionDisabled: (_dataStream$failureSt4 = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$failureSt5 = dataStream.failureStoreRetention) === null || _dataStream$failureSt5 === void 0 ? void 0 : _dataStream$failureSt5.retentionDisabled) !== null && _dataStream$failureSt4 !== void 0 ? _dataStream$failureSt4 : false
    },
    canShowDisableLifecycle: enableFailureStoreRetentionDisabling,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  });
};
exports.ConfigureFailureStoreModal = ConfigureFailureStoreModal;