"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _mappings_state_context = require("../../../mappings_state_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/name_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  validations,
  ...rest
} = _constants.PARAMETERS_DEFINITION.name.fieldConfig;
const NameParameter = ({
  isSemanticText
}) => {
  const {
    fields: {
      rootLevelFields,
      byId
    },
    documentFields: {
      fieldToAddFieldTo,
      fieldToEdit
    }
  } = (0, _mappings_state_context.useMappingsState)();
  const initialName = fieldToEdit ? byId[fieldToEdit].source.name : undefined;
  const parentId = fieldToEdit ? byId[fieldToEdit].parentId : fieldToAddFieldTo;
  const uniqueNameValidator = (0, _react.useCallback)(arg => {
    return (0, _lib.validateUniqueName)({
      rootLevelFields,
      byId
    }, initialName, parentId)(arg);
  }, [rootLevelFields, byId, initialName, parentId]);
  const nameConfig = (0, _react.useMemo)(() => ({
    ...rest,
    label: isSemanticText ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.semanticTextNameFieldLabel', {
      defaultMessage: 'New field name'
    }) : rest.label,
    validations: [...validations, {
      validator: uniqueNameValidator
    }]
  }), [isSemanticText, uniqueNameValidator]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: nameConfig,
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'nameParameterInput'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.NameParameter = NameParameter;