"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _edit_field = require("../fields/edit_field");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/index_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexParameter = ({
  indexOptions = _constants.PARAMETERS_OPTIONS.index_options,
  hasIndexOptions = true,
  config = (0, _lib.getFieldConfig)('index_options')
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.searchableFieldTitle', {
    defaultMessage: 'Searchable'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.searchableFieldDescription', {
    defaultMessage: 'Allow the field to be searched.'
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.indexDocLinkText', {
      defaultMessage: 'Searchable documentation'
    }),
    href: _documentation.documentationService.getIndexLink()
  },
  formFieldPath: "index",
  "data-test-subj": "indexParameter",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 3
  }
}, hasIndexOptions ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "index_options",
  config: config,
  component: _shared_imports.Field,
  componentProps: {
    euiFieldProps: {
      options: indexOptions
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 7
  }
}) : undefined);
exports.IndexParameter = IndexParameter;