"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutProps = exports.ComponentTemplateDetailsFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
var _app_context = require("../../../app_context");
var _component_templates_context = require("../component_templates_context");
var _components = require("../components");
var _tab_summary = require("./tab_summary");
var _tabs = require("./tabs");
var _manage_button = require("./manage_button");
var _locator = require("../../../../locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_details/component_template_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultFlyoutProps = exports.defaultFlyoutProps = {
  'data-test-subj': 'componentTemplateDetails',
  'aria-labelledby': 'componentTemplateDetailsFlyoutTitle'
};

// All component templates for integrations end in @custom
const isIntegrationsComponentTemplate = name => {
  return name.toLowerCase().endsWith('@custom');
};
const ComponentTemplateDetailsFlyoutContent = ({
  componentTemplateName,
  onClose,
  actions,
  showSummaryCallToAction
}) => {
  const {
    url
  } = (0, _app_context.useAppContext)();
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const locator = url.locators.get(_locator.INDEX_MANAGEMENT_LOCATOR_ID);
  const decodedComponentTemplateName = (0, _shared_imports.attemptToURIDecode)(componentTemplateName);
  const {
    data: componentTemplateDetails,
    isLoading,
    error
  } = api.useLoadComponentTemplate(decodedComponentTemplateName);
  const [activeTab, setActiveTab] = (0, _react.useState)('summary');
  let content;
  const createTemplateLink = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
    page: 'create_component_template',
    componentTemplate: decodedComponentTemplateName
  });
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateDetails.loadingIndexTemplateDescription",
      defaultMessage: "Loading component template\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }));
  } else if (error) {
    if ((error === null || error === void 0 ? void 0 : error.error) === 'Not Found' && isIntegrationsComponentTemplate(decodedComponentTemplateName)) {
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.componentTemplateDetails.createMissingIntegrationTemplate.calloutTitle",
          defaultMessage: "Custom template doesn't exist",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 13
          }
        }),
        color: "warning",
        iconType: "warning",
        "data-test-subj": "missingCustomComponentTemplate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.createMissingIntegrationTemplate.text",
        defaultMessage: "The custom template {templateName} doesn't exist.",
        values: {
          templateName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 121,
              columnNumber: 31
            }
          }, decodedComponentTemplateName)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      })), createTemplateLink && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "warning",
        href: createTemplateLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.createMissingIntegrationTemplate.button",
        defaultMessage: "Create component template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 15
        }
      })));
    } else {
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.componentTemplateDetails.loadingErrorMessage",
          defaultMessage: "Error loading component template",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 13
          }
        }),
        color: "danger",
        iconType: "warning",
        "data-test-subj": "sectionError",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 11
        }
      }, error.message));
    }
  } else if (componentTemplateDetails) {
    const {
      template: {
        settings,
        mappings,
        aliases
      }
    } = componentTemplateDetails;
    const tabToComponentMap = {
      summary: /*#__PURE__*/_react.default.createElement(_tab_summary.TabSummary, {
        componentTemplateDetails: componentTemplateDetails,
        showCallToAction: showSummaryCallToAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 9
        }
      }),
      settings: /*#__PURE__*/_react.default.createElement(_shared_imports.TabSettings, {
        settings: settings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 17
        }
      }),
      mappings: /*#__PURE__*/_react.default.createElement(_shared_imports.TabMappings, {
        mappings: mappings,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 17
        }
      }),
      aliases: /*#__PURE__*/_react.default.createElement(_shared_imports.TabAliases, {
        aliases: aliases,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 16
        }
      })
    };
    const tabContent = tabToComponentMap[activeTab];
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tabs.ComponentTemplateTabs, {
      activeTab: activeTab,
      setActiveTab: setActiveTab,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }), tabContent);
  }
  const isManaged = componentTemplateDetails === null || componentTemplateDetails === void 0 ? void 0 : componentTemplateDetails._kbnMeta.isManaged;
  const isDeprecated = componentTemplateDetails === null || componentTemplateDetails === void 0 ? void 0 : componentTemplateDetails.deprecated;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "componentTemplateDetailsFlyoutTitle",
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, decodedComponentTemplateName))), isDeprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_components.DeprecatedBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  })), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.managedBadgeLabel",
    defaultMessage: "Managed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, content), actions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": "footer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClose,
    "data-test-subj": "closeDetailsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateDetails.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }))), componentTemplateDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_manage_button.ManageButton, {
    actions: actions,
    componentTemplateDetails: componentTemplateDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  })))));
};
exports.ComponentTemplateDetailsFlyoutContent = ComponentTemplateDetailsFlyoutContent;