"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexLifecycleTab = exports.IndexLifecycleSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _navigation = require("../../application/services/navigation");
var _lib = require("../../application/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/extend_index_management/components/index_lifecycle_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexLifecycleSummary = ({
  index,
  getUrlForApp
}) => {
  var _phaseToBadgeMapping;
  const {
    ilm: ilmData
  } = index;
  // only ILM managed indices render the ILM tab
  const ilm = ilmData;
  const phaseColors = (0, _lib.usePhaseColors)();
  const phaseToBadgeMapping = {
    hot: {
      color: phaseColors.hot,
      label: 'Hot'
    },
    warm: {
      color: phaseColors.warm,
      label: 'Warm'
    },
    cold: {
      color: phaseColors.cold,
      label: 'Cold'
    },
    frozen: {
      color: phaseColors.frozen,
      label: 'Frozen'
    },
    delete: {
      color: 'default',
      label: 'Delete'
    }
  };

  // if ilm.phase is an unexpected value, then display a default badge
  const phaseBadgeConfig = (_phaseToBadgeMapping = phaseToBadgeMapping[ilm.phase]) !== null && _phaseToBadgeMapping !== void 0 ? _phaseToBadgeMapping : {
    color: 'default',
    label: ilm.phase
  };
  const lifecycleProperties = [{
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.policyNameTitle', {
      defaultMessage: 'Policy name'
    }),
    description: ilm.policy
  }, {
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentPhaseTitle', {
      defaultMessage: 'Current phase'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: phaseBadgeConfig.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 20
      }
    }, phaseBadgeConfig.label)
  }];
  if (ilm.action) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTitle', {
        defaultMessage: 'Current action'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 20
        }
      }, ilm.action)
    });
  }
  if (ilm.action_time_millis) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTimeTitle', {
        defaultMessage: 'Current action time'
      }),
      description: (0, _momentTimezone.default)(ilm.action_time_millis).format('YYYY-MM-DD HH:mm:ss')
    });
  }
  if (ilm.step) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentStepTitle', {
        defaultMessage: 'Current step'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 20
        }
      }, ilm.step)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: (0, _react2.css)`
            min-width: 400px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyPropertiesPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Lifecycle policy",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.policyCardTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    href: getUrlForApp('management', {
      path: `data/index_lifecycle_management/${(0, _navigation.getPolicyEditPath)(ilm.policy)}`
    }),
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Edit policy in ILM",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.ilmLinkLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m",
    type: "responsiveColumn",
    columnWidths: [1, 1],
    listItems: lifecycleProperties,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: (0, _react2.css)`
            min-width: 600px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, ilm.step_info && ilm.step === 'ERROR' &&
  /*#__PURE__*/
  // there is an error
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "danger",
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyErrorPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Lifecycle error",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.lifecycleErrorTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  }, JSON.stringify({
    failed_step: ilm.failed_step,
    step_info: ilm.step_info
  }, null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  })), ilm.step_info && ilm.step !== 'ERROR' &&
  /*#__PURE__*/
  // ILM is waiting for the step to complete
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyStepPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current step info",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.stepInfoTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 19
    }
  }, JSON.stringify(ilm.step_info, null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  })), ilm.phase_execution && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "phaseDefinitionPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current phase definition",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.phaseDefinitionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }, JSON.stringify(ilm.phase_execution, null, 2))))));
};
exports.IndexLifecycleSummary = IndexLifecycleSummary;
const indexLifecycleTab = exports.indexLifecycleTab = {
  id: 'ilm',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Index lifecycle",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.tabHeaderLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 5
    }
  }),
  order: 50,
  renderTabContent: IndexLifecycleSummary,
  shouldRenderTab: ({
    index
  }) => {
    return !!index.ilm && index.ilm.managed;
  }
};