"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _lib = require("../../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phase_icon/phase_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = ({
  enabled,
  phase
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const phaseIconColors = (0, _lib.usePhaseColors)();
  return {
    container: (0, _react2.css)`
      width: ${enabled ? euiTheme.size.xl : euiTheme.size.base};
      height: ${enabled ? euiTheme.size.xl : euiTheme.size.base};
      display: flex;
      justify-content: center;
      align-items: center;
      border-radius: 50%;
      background-color: ${!enabled ? euiTheme.colors.backgroundBaseFormsPrepend : phaseIconColors[phase]};
      ${!enabled && `margin: ${euiTheme.size.s};`}
    `,
    icon: phase === 'delete' ? euiTheme.colors.backgroundFilledText : euiTheme.colors.backgroundBasePlain
  };
};
const PhaseIcon = ({
  enabled,
  phase
}) => {
  const styles = useStyles({
    enabled,
    phase
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: styles.icon,
    type: phase === 'delete' ? 'trash' : 'check',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'dot',
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }));
};
exports.PhaseIcon = PhaseIcon;