"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectionToolBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/selection_tool_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SelectionToolBar = ({
  workspace,
  onSetControl
}) => {
  const haveNodes = workspace.nodes.length === 0;
  const selectAllButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectAllButtonTooltip', {
    defaultMessage: 'Select all'
  });
  const selectNoneButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNoneButtonTooltip', {
    defaultMessage: 'Select none'
  });
  const invertSelectionButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.invertSelectionButtonTooltip', {
    defaultMessage: 'Invert selection'
  });
  const selectNeighboursButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNeighboursButtonTooltip', {
    defaultMessage: 'Select neighbours'
  });
  const onSelectAllClick = () => {
    onSetControl('none');
    workspace.selectAll();
    workspace.changeHandler();
  };
  const onSelectNoneClick = () => {
    onSetControl('none');
    workspace.selectNone();
    workspace.changeHandler();
  };
  const onInvertSelectionClick = () => {
    onSetControl('none');
    workspace.selectInvert();
    workspace.changeHandler();
  };
  const onSelectNeighboursClick = () => {
    onSetControl('none');
    workspace.selectNeighbours();
    workspace.changeHandler();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    css: (0, _react2.css)`
        margin-top: 0;
        margin-bottom: 0;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectAllButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphSelectAll",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onSelectAllClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectAllButtonLabel', {
    defaultMessage: 'all'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectNoneButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphSelectNone",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onSelectNoneClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNoneButtonLabel', {
    defaultMessage: 'none'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: invertSelectionButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphInvertSelection",
    size: "s",
    isDisabled: haveNodes,
    color: "text",
    onClick: onInvertSelectionClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.invertSelectionButtonLabel', {
    defaultMessage: 'invert'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectNeighboursButtonMsg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "graphLinkedSelection",
    size: "s",
    isDisabled: workspace.selectedNodes.length === 0,
    color: "text",
    onClick: onSelectNeighboursClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.selectNeighboursButtonLabel', {
    defaultMessage: 'linked'
  })))));
};
exports.SelectionToolBar = SelectionToolBar;