"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNodeItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _icon_renderer = require("../icon_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/selected_node_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function fixIconOffset(node) {
  var _node$icon;
  const offset = (0, _icon_renderer.getIconOffset)(node.icon) || {
    x: 0,
    y: 0
  };
  const finalOffset = {
    x: offset.x / 2,
    y: offset.y / 2
  };
  // Maki icons need to be offset a little bit more on the right (~0.5px)
  if (((_node$icon = node.icon) === null || _node$icon === void 0 ? void 0 : _node$icon.package) === 'maki') {
    finalOffset.x += 0.5;
  }
  return finalOffset;
}
const SelectedNodeItem = ({
  node,
  isHighlighted,
  onSelectedFieldClick,
  onDeselectNode
}) => {
  const offset = fixIconOffset(node);
  const xsFontSize = (0, _eui.useEuiFontSize)('xs', {
    unit: 'px'
  }).fontSize;
  return /*#__PURE__*/_react.default.createElement("button", {
    className: "gphSelectionList__field",
    "aria-hidden": "true",
    onClick: () => onSelectedFieldClick(node),
    css: ({
      euiTheme
    }) => (0, _react2.css)`
        line-height: ${euiTheme.font.lineHeightMultiplier};
        margin: ${euiTheme.size.xs} 0;
        cursor: pointer;
        width: 100%;
        display: block;
        text-align: left;

        > * {
          vertical-align: middle;
        }

        ${isHighlighted ? `background: ${euiTheme.colors.lightShade}` : ''}
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "24",
    height: "24",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("circle", {
    css: ({
      euiTheme
    }) => (0, _react2.css)`
              fill: ${euiTheme.colors.mediumShade};
            `,
    r: "10",
    cx: "12",
    cy: "12",
    style: {
      fill: node.color
    },
    onClick: () => onDeselectNode(node),
    "data-test-subj": `graph-selected-${node.label}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
    color: node.color,
    icon: node.icon,
    css: (0, _react2.css)`
            font-size: ${xsFontSize};
          `,
    x: offset.x,
    y: offset.y,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, node.label), node.numChildren > 0 && /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 32
    }
  }, " (+", node.numChildren, ")"));
};
exports.SelectedNodeItem = SelectedNodeItem;