"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDowns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _icon_renderer = require("../icon_renderer");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/drill_downs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DrillDowns = ({
  urlTemplates,
  openUrlTemplate
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  }), ' ', _i18n.i18n.translate('xpack.graph.sidebar.drillDownsTitle', {
    defaultMessage: 'Drill-downs'
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarPanelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, urlTemplates.length === 0 && /*#__PURE__*/_react.default.createElement("p", {
    className: "help-block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.drillDowns.noDrillDownsHelpText', {
    defaultMessage: 'Configure drill-downs from the settings menu'
  })), /*#__PURE__*/_react.default.createElement("ul", {
    className: "list-group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, urlTemplates.map(urlTemplate => {
    const onOpenUrlTemplate = () => openUrlTemplate(urlTemplate);
    return /*#__PURE__*/_react.default.createElement("li", {
      className: "list-group-item",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 15
      }
    }, urlTemplate.icon && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: urlTemplate.icon,
      css: _styles.noUserSelectStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 21
      }
    }), ' '), /*#__PURE__*/_react.default.createElement("a", {
      "aria-hidden": "true",
      onClick: onOpenUrlTemplate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 17
      }
    }, urlTemplate.description));
  }))));
};
exports.DrillDowns = DrillDowns;