"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKibanaRequestFromAuth = createKibanaRequestFromAuth;
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createKibanaRequestFromAuth(authorizationHeader) {
  const requestHeaders = {
    authorization: authorizationHeader.toString()
  };
  const fakeRawRequest = {
    headers: requestHeaders,
    path: '/'
  };

  // Since we're using API keys and accessing elasticsearch can only be done
  // via a request, we're faking one with the proper authorization headers.
  const fakeRequest = (0, _coreHttpServerUtils.kibanaRequestFactory)(fakeRawRequest);
  return fakeRequest;
}