"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkAssets = getBulkAssets;
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKibanaLinkForESAsset = (type, id) => {
  switch (type) {
    case 'index':
      return `/app/management/data/index_management/indices/index_details?indexName=${id}`;
    case 'index_template':
      return `/app/management/data/index_management/templates/${id}`;
    case 'component_template':
      return `/app/management/data/index_management/component_templates/${id}`;
    case 'ingest_pipeline':
      return `/app/management/ingest/ingest_pipelines/?pipeline=${id}`;
    case 'ilm_policy':
      return `/app/management/data/index_lifecycle_management/policies/edit/${id}`;
    case 'data_stream_ilm_policy':
      return `/app/management/data/index_lifecycle_management/policies/edit/${id}`;
    case 'transform':
      return `/app/management/data/transform?_a=(transform:(queryText:${id}))`;
    case 'ml_model':
      return `/app/management/ml/trained_models?_a=(trained_models:(queryText:'model_id:(${id})'))`;
    case 'esql_view':
    // TODO Update when feature flag is turned on https://github.com/elastic/kibana/issues/244655
    default:
      return '';
  }
};
async function getBulkAssets(soClient, soTypeRegistry, assetIds) {
  const {
    resolved_objects: resolvedObjects
  } = await soClient.bulkResolve(assetIds);
  const types = {};
  const res = resolvedObjects.map(({
    saved_object: savedObject
  }) => savedObject).filter(savedObject => {
    var _savedObject$error;
    return (savedObject === null || savedObject === void 0 ? void 0 : (_savedObject$error = savedObject.error) === null || _savedObject$error === void 0 ? void 0 : _savedObject$error.statusCode) !== 404 && _constants.displayedAssetTypesLookup.has(savedObject.type);
  }).map(obj => {
    var _types$obj$type$manag2, _types$obj$type2, _types$obj$type2$mana, _types$obj$type2$mana2, _obj$attributes, _obj$attributes2;
    // Kibana SOs are registered with an app URL getter, so try to use that
    // for retrieving links to assets whenever possible
    if (!types[obj.type]) {
      types[obj.type] = soTypeRegistry.getType(obj.type);
    }
    let appLink = '';
    try {
      var _types$obj$type, _types$obj$type$manag;
      if ((_types$obj$type = types[obj.type]) !== null && _types$obj$type !== void 0 && (_types$obj$type$manag = _types$obj$type.management) !== null && _types$obj$type$manag !== void 0 && _types$obj$type$manag.getInAppUrl) {
        var _ref;
        appLink = ((_ref = types[obj.type].management.getInAppUrl(obj)) === null || _ref === void 0 ? void 0 : _ref.path) || '';
      }
    } catch (e) {
      // Ignore errors from `getInAppUrl()`
      // This can happen if user can't access the saved object (i.e. in a different space)
    }

    // TODO: Ask for Kibana SOs to have `getInAppUrl()` registered so that the above works safely:
    //  security-rule
    //  csp-rule-template
    //  osquery-pack-asset
    //  osquery-saved-query

    // If we still don't have an app link at this point, manually map them (only ES types)
    if (!appLink) {
      if (Object.values(_common.ElasticsearchAssetType).includes(obj.type)) {
        appLink = getKibanaLinkForESAsset(obj.type, obj.id);
      }
    }
    const title = (_types$obj$type$manag2 = (_types$obj$type2 = types[obj.type]) === null || _types$obj$type2 === void 0 ? void 0 : (_types$obj$type2$mana = _types$obj$type2.management) === null || _types$obj$type2$mana === void 0 ? void 0 : (_types$obj$type2$mana2 = _types$obj$type2$mana.getTitle) === null || _types$obj$type2$mana2 === void 0 ? void 0 : _types$obj$type2$mana2.call(_types$obj$type2$mana, obj)) !== null && _types$obj$type$manag2 !== void 0 ? _types$obj$type$manag2 : (_obj$attributes = obj.attributes) === null || _obj$attributes === void 0 ? void 0 : _obj$attributes.title;
    return {
      id: obj.id,
      type: obj.type,
      updatedAt: obj.updated_at,
      attributes: {
        title,
        description: (_obj$attributes2 = obj.attributes) === null || _obj$attributes2 === void 0 ? void 0 : _obj$attributes2.description
      },
      appLink
    };
  });
  return res;
}