"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEsqlViews = deleteEsqlViews;
var _pMap = _interopRequireDefault(require("p-map"));
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteEsqlViews(esClient, idsToDelete) {
  await (0, _pMap.default)(idsToDelete, async id => await esClient.transport.request({
    method: 'DELETE',
    path: `/_query/view/${id}`
  }, {
    ignore: [404, 400]
  }), {
    concurrency: _constants.MAX_CONCURRENT_ESQL_VIEWS_OPERATIONS
  });
}