"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installEsqlViews = installEsqlViews;
var _pMap = _interopRequireDefault(require("p-map"));
var _jsYaml = require("js-yaml");
var _errors = require("../../../../errors");
var _types = require("../../../../../common/types");
var _archive = require("../../archive");
var _es_assets_reference = require("../../packages/es_assets_reference");
var _retry = require("../retry");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function installEsqlViews({
  packageInstallContext,
  esClient,
  savedObjectsClient,
  logger,
  esReferences
}) {
  const {
    packageInfo
  } = packageInstallContext;
  const esqlViewPaths = packageInstallContext.paths.filter(path => isEsqlViews(path));
  if (!esqlViewPaths.length) return esReferences;
  const esqlViewAssetsMap = new Map();
  await packageInstallContext.archiveIterator.traverseEntries(async entry => {
    if (!entry.buffer) {
      return;
    }
    esqlViewAssetsMap.set(entry.path, entry.buffer);
  }, path => esqlViewPaths.includes(path));
  const esqlViews = esqlViewPaths.map(path => {
    const assetData = (0, _archive.getAssetFromAssetsMap)(esqlViewAssetsMap, path).toString('utf-8');
    const data = path.endsWith('.yml') ? (0, _jsYaml.load)(assetData) : JSON.parse(assetData);
    return {
      name: data.name,
      query: data.query
    };
  });
  esReferences = await (0, _es_assets_reference.updateEsAssetReferences)(savedObjectsClient, packageInfo.name, esReferences, {
    assetsToAdd: esqlViews.map(esqlView => ({
      type: _types.ElasticsearchAssetType.esqlView,
      id: esqlView.name
    }))
  });
  await (0, _pMap.default)(esqlViews, async esqlView => {
    try {
      await (0, _retry.retryTransientEsErrors)(() => esClient.transport.request({
        method: 'PUT',
        path: '/_query/view/' + esqlView.name,
        body: {
          query: esqlView.query
        }
      }), {
        logger
      });
    } catch (err) {
      throw new _errors.PackageInvalidArchiveError(`Couldn't install esql views: ${err.message}`);
    }
  }, {
    concurrency: _constants.MAX_CONCURRENT_ESQL_VIEWS_OPERATIONS
  });
  return esReferences;
}
const isEsqlViews = path => {
  const pathParts = (0, _archive.getPathParts)(path);
  return pathParts.type === _types.ElasticsearchAssetType.esqlView;
};