"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = exports.ListDataStreamsResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _api_privileges = require("../../constants/api_privileges");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _data_stream = require("../../../common/types/rest_spec/data_stream");
var _errors = require("../schema/errors");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListDataStreamsResponseSchema = exports.ListDataStreamsResponseSchema = _configSchema.schema.object({
  data_streams: _configSchema.schema.arrayOf(_configSchema.schema.object({
    index: _configSchema.schema.string(),
    dataset: _configSchema.schema.string(),
    namespace: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    package: _configSchema.schema.string(),
    package_version: _configSchema.schema.string(),
    last_activity_ms: _configSchema.schema.number(),
    size_in_bytes: _configSchema.schema.number(),
    size_in_bytes_formatted: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    dashboards: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      title: _configSchema.schema.string()
    })),
    serviceDetails: _configSchema.schema.nullable(_configSchema.schema.object({
      environment: _configSchema.schema.string(),
      serviceName: _configSchema.schema.string()
    }))
  }))
});
const registerRoutes = router => {
  // List of data streams
  router.versioned.get({
    path: _constants2.DATA_STREAM_API_ROUTES.LIST_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Get data streams`,
    options: {
      tags: ['oas-tag:Data streams']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {},
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => ListDataStreamsResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.getListHandler);

  // Check for deprecated ILM policies
  router.versioned.get({
    path: _constants2.DATA_STREAM_API_ROUTES.DEPRECATED_ILM_CHECK_PATTERN,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Check if Fleet-managed component templates are using deprecated ILM policies that require manual migration`,
    options: {
      tags: ['internal', 'oas-tag:Data streams']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: {},
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _data_stream.DeprecatedILMPolicyCheckResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.getDeprecatedILMCheckHandler);
};
exports.registerRoutes = registerRoutes;