"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkGetAgentPoliciesQuery = exports.sendUpdateAgentPolicyForRq = exports.sendUpdateAgentPolicy = exports.sendResetOnePreconfiguredAgentPolicy = exports.sendResetAllPreconfiguredAgentPolicies = exports.sendGetOneAgentPolicyFull = exports.sendGetOneAgentPolicy = exports.sendGetAgentPolicies = exports.sendDeleteAgentPolicyForRq = exports.sendDeleteAgentPolicy = exports.sendCreateAgentPolicyForRq = exports.sendCreateAgentPolicy = exports.sendCopyAgentPolicy = exports.sendBulkGetAgentPoliciesForRq = exports.sendBulkGetAgentPolicies = void 0;
exports.useDeleteAgentPolicyMutation = useDeleteAgentPolicyMutation;
exports.useGetAgentPoliciesQuery = exports.useGetAgentPolicies = void 0;
exports.useGetAutoUpgradeAgentsStatusQuery = useGetAutoUpgradeAgentsStatusQuery;
exports.useGetOneAgentPolicyFull = exports.useGetOneAgentPolicy = exports.useGetListOutputsForPolicies = exports.useGetInfoOutputsForPolicy = void 0;
var _reactQuery = require("@kbn/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAgentPolicies = query => {
  return (0, _use_request.useRequest)({
    path: _services.agentPolicyRouteService.getListPath(),
    method: 'get',
    // Make noAgentCount the default as it have a significant performance impact
    query: {
      ...(query !== null && query !== void 0 ? query : {}),
      noAgentCount: (query === null || query === void 0 ? void 0 : query.noAgentCount) === false ? false : true
    },
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetAgentPolicies = useGetAgentPolicies;
const useGetAgentPoliciesQuery = (query, options) => {
  return (0, _reactQuery.useQuery)({
    queryKey: ['agentPolicies', query],
    queryFn: () => (0, _use_request.sendRequestForRq)({
      path: _services.agentPolicyRouteService.getListPath(),
      method: 'get',
      // Make noAgentCount the default as it have a significant performance impact
      query: {
        ...(query !== null && query !== void 0 ? query : {}),
        noAgentCount: (query === null || query === void 0 ? void 0 : query.noAgentCount) === false ? false : true
      },
      version: _constants.API_VERSIONS.public.v1
    }),
    enabled: options === null || options === void 0 ? void 0 : options.enabled
  });
};
exports.useGetAgentPoliciesQuery = useGetAgentPoliciesQuery;
const useBulkGetAgentPoliciesQuery = (ids, options) => {
  return (0, _reactQuery.useQuery)(['agentPolicies', ids], () => (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getBulkGetPath(),
    method: 'post',
    body: JSON.stringify({
      ids,
      full: options === null || options === void 0 ? void 0 : options.full
    }),
    version: _constants.API_VERSIONS.public.v1
  }));
};

/**
 * @deprecated use sendBulkGetAgentPoliciesForRq instead
 */
exports.useBulkGetAgentPoliciesQuery = useBulkGetAgentPoliciesQuery;
const sendBulkGetAgentPolicies = (ids, options) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getBulkGetPath(),
    method: 'post',
    body: JSON.stringify({
      ids,
      full: options === null || options === void 0 ? void 0 : options.full,
      ignoreMissing: options === null || options === void 0 ? void 0 : options.ignoreMissing
    }),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendBulkGetAgentPolicies = sendBulkGetAgentPolicies;
const sendBulkGetAgentPoliciesForRq = (ids, options) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getBulkGetPath(),
    method: 'post',
    body: JSON.stringify({
      ids,
      full: options === null || options === void 0 ? void 0 : options.full,
      ignoreMissing: options === null || options === void 0 ? void 0 : options.ignoreMissing
    }),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendBulkGetAgentPoliciesForRq = sendBulkGetAgentPoliciesForRq;
const sendGetAgentPolicies = query => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getListPath(),
    method: 'get',
    query,
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetAgentPolicies = sendGetAgentPolicies;
const useGetOneAgentPolicy = agentPolicyId => {
  return (0, _use_request.useConditionalRequest)({
    path: agentPolicyId ? _services.agentPolicyRouteService.getInfoPath(agentPolicyId) : undefined,
    method: 'get',
    shouldSendRequest: !!agentPolicyId,
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetOneAgentPolicy = useGetOneAgentPolicy;
const useGetOneAgentPolicyFull = agentPolicyId => {
  return (0, _use_request.useRequest)({
    path: _services.agentPolicyRouteService.getInfoFullPath(agentPolicyId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetOneAgentPolicyFull = useGetOneAgentPolicyFull;
const sendGetOneAgentPolicyFull = (agentPolicyId, query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getInfoFullPath(agentPolicyId),
    method: 'get',
    query,
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetOneAgentPolicyFull = sendGetOneAgentPolicyFull;
const sendGetOneAgentPolicy = agentPolicyId => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getInfoPath(agentPolicyId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetOneAgentPolicy = sendGetOneAgentPolicy;
function useGetAutoUpgradeAgentsStatusQuery(agentPolicyId) {
  return (0, _reactQuery.useQuery)(['auto_upgrade_agents_status'], () => (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.agentPolicyRouteService.getAutoUpgradeAgentsStatusPath(agentPolicyId),
    version: _constants.API_VERSIONS.public.v1
  }));
}
const sendCreateAgentPolicyForRq = (body, {
  withSysMonitoring
} = {
  withSysMonitoring: false
}) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getCreatePath(),
    method: 'post',
    body: JSON.stringify(body),
    query: withSysMonitoring ? {
      sys_monitoring: true
    } : {},
    version: _constants.API_VERSIONS.public.v1
  });
};

/**
 * @deprecated use sendCreateAgentPolicyForRq instead
 */
exports.sendCreateAgentPolicyForRq = sendCreateAgentPolicyForRq;
const sendCreateAgentPolicy = (body, {
  withSysMonitoring
} = {
  withSysMonitoring: false
}) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getCreatePath(),
    method: 'post',
    body: JSON.stringify(body),
    query: withSysMonitoring ? {
      sys_monitoring: true
    } : {},
    version: _constants.API_VERSIONS.public.v1
  });
};

/**
 * @deprecated use sendUpdateAgentPolicyForRq instead
 */
exports.sendCreateAgentPolicy = sendCreateAgentPolicy;
const sendUpdateAgentPolicy = (agentPolicyId, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getUpdatePath(agentPolicyId),
    method: 'put',
    body: JSON.stringify(body),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendUpdateAgentPolicy = sendUpdateAgentPolicy;
const sendUpdateAgentPolicyForRq = (agentPolicyId, body) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getUpdatePath(agentPolicyId),
    method: 'put',
    body: JSON.stringify(body),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendUpdateAgentPolicyForRq = sendUpdateAgentPolicyForRq;
const sendCopyAgentPolicy = (agentPolicyId, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getCopyPath(agentPolicyId),
    method: 'post',
    body: JSON.stringify(body)
  });
};
exports.sendCopyAgentPolicy = sendCopyAgentPolicy;
const sendDeleteAgentPolicy = body => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getDeletePath(),
    method: 'post',
    body: JSON.stringify(body),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendDeleteAgentPolicy = sendDeleteAgentPolicy;
const sendDeleteAgentPolicyForRq = body => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getDeletePath(),
    method: 'post',
    body: JSON.stringify(body),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendDeleteAgentPolicyForRq = sendDeleteAgentPolicyForRq;
function useDeleteAgentPolicyMutation() {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: sendDeleteAgentPolicy,
    onSuccess: () => {
      return queryClient.invalidateQueries(['agentPolicies']);
    }
  });
}
const sendResetOnePreconfiguredAgentPolicy = agentPolicyId => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getResetOnePreconfiguredAgentPolicyPath(agentPolicyId),
    method: 'post',
    body: JSON.stringify({}),
    version: _constants.API_VERSIONS.internal.v1
  });
};
exports.sendResetOnePreconfiguredAgentPolicy = sendResetOnePreconfiguredAgentPolicy;
const sendResetAllPreconfiguredAgentPolicies = () => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getResetAllPreconfiguredAgentPolicyPath(),
    method: 'post',
    body: JSON.stringify({}),
    version: _constants.API_VERSIONS.internal.v1
  });
};
exports.sendResetAllPreconfiguredAgentPolicies = sendResetAllPreconfiguredAgentPolicies;
const useGetListOutputsForPolicies = body => {
  return (0, _use_request.useRequest)({
    path: _services.agentPolicyRouteService.getListOutputsPath(),
    method: 'post',
    body: JSON.stringify(body),
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetListOutputsForPolicies = useGetListOutputsForPolicies;
const useGetInfoOutputsForPolicy = agentPolicyId => {
  return (0, _use_request.useConditionalRequest)({
    path: agentPolicyId ? _services.agentPolicyRouteService.getInfoOutputsPath(agentPolicyId) : undefined,
    method: 'get',
    shouldSendRequest: !!agentPolicyId,
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetInfoOutputsForPolicy = useGetInfoOutputsForPolicy;