"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkActionsContext = exports.BulkActionContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/hooks/use_bulk_actions_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const bulkActionsContext = exports.bulkActionsContext = /*#__PURE__*/_react.default.createContext({
  upgradingIntegrations: [],
  uninstallingIntegrations: [],
  rollingbackIntegrations: [],
  bulkActions: {
    setPollingBulkActions: () => {},
    setActionCompletedCallback: () => {}
  }
});
const BulkActionContextProvider = ({
  children
}) => {
  const {
    notifications: {
      toasts
    }
  } = (0, _hooks.useStartServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [pollingBulkActions, setPollingBulkActions] = (0, _react.useState)([]);
  const [actionCompletedCallback, setActionCompletedCallback] = (0, _react.useState)();
  const upgradingIntegrations = (0, _react.useMemo)(() => {
    return pollingBulkActions.filter(action => action.type === 'bulk_upgrade').flatMap(action => action.integrations);
  }, [pollingBulkActions]);
  const uninstallingIntegrations = (0, _react.useMemo)(() => {
    return pollingBulkActions.filter(action => action.type === 'bulk_uninstall').flatMap(action => action.integrations);
  }, [pollingBulkActions]);
  const rollingbackIntegrations = (0, _react.useMemo)(() => {
    return pollingBulkActions.filter(action => action.type === 'bulk_rollback').flatMap(action => action.integrations);
  }, [pollingBulkActions]);

  // Poll for task results
  (0, _reactQuery.useQueries)({
    queries: pollingBulkActions.map(action => ({
      queryKey: ['bulk-action-packages', action.taskId],
      queryFn: async () => {
        const res = action.type === 'bulk_upgrade' ? await (0, _hooks.sendGetOneBulkUpgradePackagesForRq)(action.taskId) : action.type === 'bulk_uninstall' ? await (0, _hooks.sendGetOneBulkUninstallPackagesForRq)(action.taskId) : await (0, _hooks.sendGetBulkRollbackInfoPackagesForRq)(action.taskId);
        if (res.status !== 'pending') {
          await queryClient.invalidateQueries(['get-packages']);
          setPollingBulkActions(actions => actions.filter(a => a.taskId !== action.taskId));
          if (res.status === 'success') {
            toasts.addSuccess({
              title: action.type === 'bulk_upgrade' ? _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUpgradeSuccessTitle', {
                defaultMessage: 'Upgrade succeeded'
              }) : action.type === 'bulk_uninstall' ? _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUninstallSuccessTitle', {
                defaultMessage: 'Uninstall succeeded'
              }) : _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkRollbackSuccessTitle', {
                defaultMessage: 'Rollback succeeded'
              })
            });
            if (actionCompletedCallback) {
              actionCompletedCallback('success');
            }
          } else if (res.status === 'failed') {
            var _res$error, _res$error2;
            const errorMessage = (_res$error = res.error) !== null && _res$error !== void 0 && _res$error.message ? (_res$error2 = res.error) === null || _res$error2 === void 0 ? void 0 : _res$error2.message : res.results ? res.results.filter(result => result.error).map(result => {
              var _result$error;
              return `${result.name}: ${(_result$error = result.error) === null || _result$error === void 0 ? void 0 : _result$error.message}`;
            }).join('\n') : 'Unexpected error';
            const error = new Error(errorMessage);
            toasts.addError(error, {
              title: action.type === 'bulk_upgrade' ? _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUpgradeFailedTitle', {
                defaultMessage: 'Upgrade failed'
              }) : action.type === 'bulk_uninstall' ? _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkUninstallFailedTitle', {
                defaultMessage: 'Uninstall failed'
              }) : _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.bulkActions.bulkRollbackFailedTitle', {
                defaultMessage: 'Rollback failed'
              })
            });
            if (actionCompletedCallback) {
              actionCompletedCallback('failed');
            }
          }
        }
      },
      refetchInterval: 3 * 1000
    }))
  });
  const bulkActions = (0, _react.useMemo)(() => ({
    setPollingBulkActions,
    setActionCompletedCallback
  }), [setPollingBulkActions, setActionCompletedCallback]);
  return /*#__PURE__*/_react.default.createElement(bulkActionsContext.Provider, {
    value: {
      upgradingIntegrations,
      uninstallingIntegrations,
      rollingbackIntegrations,
      bulkActions
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, children);
};
exports.BulkActionContextProvider = BulkActionContextProvider;