"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBasedPackagePoliciesTable = void 0;
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../hooks");
var _components = require("../../../../../../components");
var _persona = require("../persona");
var _package_policy_agents_cell = require("./package_policy_agents_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/policies/components/agent_based_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentBasedPackagePoliciesTable = ({
  isLoading,
  packagePolicies,
  packagePoliciesTotal,
  refreshPackagePolicies,
  pagination,
  addAgentToPolicyIdFromParams,
  showAddAgentHelpForPolicyId
}) => {
  var _packagePolicies$find, _packagePolicies$find2, _selectedPackagePolic, _selectedPackagePolic2;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const [selectedTableIndex, setSelectedTableIndex] = (0, _react.useState)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  const canReadIntegrationPolicies = (0, _hooks.useAuthz)().integrations.readIntegrationPolicies;
  const canReadAgentPolicies = (0, _hooks.useAuthz)().fleet.readAgentPolicies;
  const canShowMultiplePoliciesCell = canUseMultipleAgentPolicies && canReadIntegrationPolicies && canReadAgentPolicies;

  // Show tour help for adding agents to a policy
  const addAgentHelpForPolicyId = (_packagePolicies$find = packagePolicies.find(({
    agentPolicies
  }) => agentPolicies.find(agentPolicy => agentPolicy.id === showAddAgentHelpForPolicyId))) === null || _packagePolicies$find === void 0 ? void 0 : (_packagePolicies$find2 = _packagePolicies$find.packagePolicy) === null || _packagePolicies$find2 === void 0 ? void 0 : _packagePolicies$find2.id;

  // Handle the "add agent" link displayed in post-installation toast notifications in the case
  // where a user is clicking the link while on the package policies listing page
  const [flyoutOpenForPolicyId, setFlyoutOpenForPolicyId] = (0, _react.useState)(addAgentToPolicyIdFromParams || null);
  (0, _react.useEffect)(() => {
    const unlisten = history.listen(location => {
      const params = new URLSearchParams(location.search);
      const addAgentToPolicyId = params.get('addAgentToPolicyId');
      if (addAgentToPolicyId) {
        setFlyoutOpenForPolicyId(addAgentToPolicyId);
      }
    });
    return () => unlisten();
  }, [history]);
  const selectedPolicies = selectedTableIndex !== undefined ? packagePolicies[selectedTableIndex] : undefined;
  const selectedAgentPolicies = selectedPolicies === null || selectedPolicies === void 0 ? void 0 : selectedPolicies.agentPolicies;
  const selectedPackagePolicy = selectedPolicies === null || selectedPolicies === void 0 ? void 0 : selectedPolicies.packagePolicy;
  const flyoutPolicy = (selectedAgentPolicies === null || selectedAgentPolicies === void 0 ? void 0 : selectedAgentPolicies.length) === 1 ? selectedAgentPolicies[0] : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: packagePolicies || [],
    columns: [{
      field: 'packagePolicy.name',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.name', {
        defaultMessage: 'Integration policy'
      }),
      render(_, {
        agentPolicies,
        packagePolicy
      }) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          className: "eui-textTruncate",
          "data-test-subj": "integrationNameLink",
          href: getHref('integration_policy_edit', {
            packagePolicyId: packagePolicy.id
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 17
          }
        }, packagePolicy.name);
      }
    }, {
      field: 'packagePolicy.package.version',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.version', {
        defaultMessage: 'Version'
      }),
      render(_version, {
        agentPolicies,
        packagePolicy
      }) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          wrap: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textNoWrap",
          "data-test-subj": "packageVersionText",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.integrationList.packageVersion",
          defaultMessage: "v{version}",
          values: {
            version: _version
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 23
          }
        }))), agentPolicies.length > 0 && packagePolicy.hasUpgrade && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          minWidth: "0",
          href: `${getHref('upgrade_package_policy', {
            policyId: agentPolicies[0].id,
            packagePolicyId: packagePolicy.id
          })}?from=integrations-policy-list`,
          "data-test-subj": "integrationPolicyUpgradeBtn",
          isDisabled: !canWriteIntegrationPolicies,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",
          defaultMessage: "Upgrade",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 25
          }
        }))));
      }
    }, {
      field: 'packagePolicy.policy_ids',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentPolicy', {
        defaultMessage: 'Agent policies'
      }),
      truncateText: true,
      render(ids, {
        agentPolicies,
        packagePolicy
      }) {
        return agentPolicies.length > 0 ? canShowMultiplePoliciesCell ? /*#__PURE__*/_react.default.createElement(_components.MultipleAgentPoliciesSummaryLine, {
          policies: agentPolicies,
          packagePolicyId: packagePolicy.id,
          onAgentPoliciesChange: refreshPackagePolicies,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 19
          }
        }) : /*#__PURE__*/_react.default.createElement(_components.AgentPolicySummaryLine, {
          policy: agentPolicies[0],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 19
          }
        }) : ids.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.integrationList.noAgentPolicies",
          defaultMessage: "No agent policies",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 19
          }
        })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: "warning",
          color: "warning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 19
          }
        }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.integrationList.agentPolicyDeletedWarning",
          defaultMessage: "Policy not found",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 199,
            columnNumber: 19
          }
        }));
      }
    }, {
      field: 'packagePolicy.updated_by',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedBy', {
        defaultMessage: 'Last updated by'
      }),
      truncateText: true,
      render(updatedBy) {
        return /*#__PURE__*/_react.default.createElement(_persona.Persona, {
          size: "s",
          name: updatedBy,
          title: updatedBy,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 214,
            columnNumber: 22
          }
        });
      }
    }, {
      field: 'packagePolicy.updated_at',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedAt', {
        defaultMessage: 'Last updated'
      }),
      truncateText: true,
      render(updatedAt) {
        return /*#__PURE__*/_react.default.createElement("span", {
          className: "eui-textTruncate",
          title: updatedAt,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 225,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
          value: updatedAt,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 226,
            columnNumber: 19
          }
        }));
      }
    }, {
      field: '',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentCount', {
        defaultMessage: 'Agents'
      }),
      render({
        agentPolicies,
        packagePolicy,
        rowIndex
      }) {
        if (agentPolicies.length === 0) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "xs",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 247,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epm.packageDetails.integrationList.noAgents",
            defaultMessage: "No agents",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 248,
              columnNumber: 21
            }
          }));
        }
        return /*#__PURE__*/_react.default.createElement(_package_policy_agents_cell.PackagePolicyAgentsCell, {
          agentPolicies: agentPolicies,
          onAddAgent: () => {
            setSelectedTableIndex(rowIndex);
            setFlyoutOpenForPolicyId(agentPolicies[0].id);
          },
          hasHelpPopover: addAgentHelpForPolicyId === packagePolicy.id,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 256,
            columnNumber: 17
          }
        });
      }
    }, {
      field: '',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.actions', {
        defaultMessage: 'Actions'
      }),
      width: '8ch',
      align: 'right',
      render({
        agentPolicies,
        packagePolicy
      }) {
        const agentPolicy = agentPolicies[0]; // TODO: handle multiple agent policies
        return /*#__PURE__*/_react.default.createElement(_components.PackagePolicyActionsMenu, {
          agentPolicies: agentPolicies,
          packagePolicy: packagePolicy,
          showAddAgent: true,
          upgradePackagePolicyHref: agentPolicy ? `${getHref('upgrade_package_policy', {
            policyId: agentPolicy.id,
            packagePolicyId: packagePolicy.id
          })}?from=integrations-policy-list` : undefined,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 283,
            columnNumber: 17
          }
        });
      }
    }],
    loading: isLoading,
    "data-test-subj": "integrationPolicyTable",
    pagination: {
      pageIndex: pagination.pagination.currentPage - 1,
      pageSize: pagination.pagination.pageSize,
      totalItemCount: packagePoliciesTotal,
      pageSizeOptions: pagination.pageSizeOptions
    },
    onChange: ({
      page
    }) => {
      pagination.setPagination({
        currentPage: page.index + 1,
        pageSize: page.size
      });
    },
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.loadingPoliciesMessage",
      defaultMessage: "Loading integration policies\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.noPoliciesMessage",
      defaultMessage: "No integration policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), flyoutOpenForPolicyId && selectedAgentPolicies && !isLoading && /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    onClose: () => {
      setFlyoutOpenForPolicyId(null);
      const {
        addAgentToPolicyId,
        ...rest
      } = (0, _queryString.parse)(search);
      history.replace({
        search: (0, _queryString.stringify)(rest)
      });
    },
    agentPolicy: flyoutPolicy,
    selectedAgentPolicies: selectedAgentPolicies,
    isIntegrationFlow: true,
    installedPackagePolicy: {
      name: (selectedPackagePolicy === null || selectedPackagePolicy === void 0 ? void 0 : (_selectedPackagePolic = selectedPackagePolicy.package) === null || _selectedPackagePolic === void 0 ? void 0 : _selectedPackagePolic.name) || '',
      version: (selectedPackagePolicy === null || selectedPackagePolicy === void 0 ? void 0 : (_selectedPackagePolic2 = selectedPackagePolicy.package) === null || _selectedPackagePolic2 === void 0 ? void 0 : _selectedPackagePolic2.version) || ''
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 9
    }
  }));
};
exports.AgentBasedPackagePoliciesTable = AgentBasedPackagePoliciesTable;