"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceTitleMap = exports.DisplayedAssetsFromPackageInfo = exports.AssetTitleMap = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// only allow Kibana assets for the kibana key, ES assets for elasticsearch, etc

const DisplayedAssetsFromPackageInfo = exports.DisplayedAssetsFromPackageInfo = {
  kibana: Object.values(_types.KibanaAssetType),
  elasticsearch: Object.values(_types.ElasticsearchAssetType)
};
const AssetTitleMap = exports.AssetTitleMap = {
  // Kibana
  // Duplication is because some assets are listed from package paths (snake cased)
  // and some are from saved objects (kebab cased)
  dashboard: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.dashboards', {
    defaultMessage: 'Dashboards'
  }),
  lens: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.lens', {
    defaultMessage: 'Lens'
  }),
  visualization: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.visualizations', {
    defaultMessage: 'Visualizations'
  }),
  search: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.savedSearches', {
    defaultMessage: 'Discover sessions'
  }),
  'index-pattern': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indexPatterns', {
    defaultMessage: 'Data views'
  }),
  index_pattern: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indexPatterns', {
    defaultMessage: 'Data views'
  }),
  map: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.maps', {
    defaultMessage: 'Maps'
  }),
  'security-ai-prompt': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.securityAIPrompt', {
    defaultMessage: 'Security AI prompt'
  }),
  security_ai_prompt: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.securityAIPrompt', {
    defaultMessage: 'Security AI prompt'
  }),
  'security-rule': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.securityRules', {
    defaultMessage: 'Security rules'
  }),
  security_rule: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.securityRules', {
    defaultMessage: 'Security rules'
  }),
  'csp-rule-template': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.cloudSecurityPostureRuleTemplate', {
    defaultMessage: 'Benchmark rules'
  }),
  csp_rule_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.cloudSecurityPostureRuleTemplate', {
    defaultMessage: 'Benchmark rules'
  }),
  alerting_rule_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.alertingRuleTemplates', {
    defaultMessage: 'Alerting rule templates'
  }),
  'ml-module': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.mlModules', {
    defaultMessage: 'Anomaly detection configurations'
  }),
  ml_module: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.mlModules', {
    defaultMessage: 'Anomaly detection configurations'
  }),
  tag: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.tag', {
    defaultMessage: 'Tags'
  }),
  'osquery-pack-asset': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osqueryPackAssets', {
    defaultMessage: 'Osquery packs'
  }),
  osquery_pack_asset: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osqueryPackAssets', {
    defaultMessage: 'Osquery packs'
  }),
  'osquery-saved-query': _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osquerySavedQuery', {
    defaultMessage: 'Osquery saved queries'
  }),
  osquery_saved_query: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osquerySavedQuery', {
    defaultMessage: 'Osquery saved queries'
  }),
  // ES
  ilm_policy: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.ilmPolicies', {
    defaultMessage: 'ILM policies'
  }),
  ingest_pipeline: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.ingestPipelines', {
    defaultMessage: 'Ingest pipelines'
  }),
  transform: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.transforms', {
    defaultMessage: 'Transforms'
  }),
  index: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indices', {
    defaultMessage: 'Indices'
  }),
  index_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indexTemplates', {
    defaultMessage: 'Index templates'
  }),
  component_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.componentTemplates', {
    defaultMessage: 'Component templates'
  }),
  data_stream_ilm_policy: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.dataStreamILM', {
    defaultMessage: 'Data stream ILM policies'
  }),
  ml_model: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.mlModels', {
    defaultMessage: 'ML models'
  }),
  view: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.views', {
    defaultMessage: 'Views'
  }),
  knowledge_base: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.knowledgeBase', {
    defaultMessage: 'Knowledge base'
  }),
  alert: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.rules', {
    defaultMessage: 'Rules'
  }),
  esql_view: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.esqlViews', {
    defaultMessage: 'ES|QL views'
  })
};
const ServiceTitleMap = exports.ServiceTitleMap = {
  kibana: 'Kibana',
  elasticsearch: 'Elasticsearch'
};