"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputStreamConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../../../../../../common/constants");
var _hooks = require("../../../../../../../../hooks");
var _services = require("../../../../../../../../../common/services");
var _components = require("../../../../../../components");
var _services2 = require("../../../services");
var _datastream_pipelines = require("../../datastream_pipelines");
var _datastream_mappings = require("../../datastream_mappings");
var _datastream_hooks = require("../../datastream_hooks");
var _package_policy_input_var_field = require("./package_policy_input_var_field");
var _hooks2 = require("./hooks");
var _sort_datastreams = require("./sort_datastreams");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/package_policy_input_stream.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ScrollAnchor = _styledComponents.default.div`
  display: none;
  scroll-margin-top: var(--euiFixedHeadersOffset, 0);
`;
const PackagePolicyInputStreamConfig = exports.PackagePolicyInputStreamConfig = /*#__PURE__*/(0, _react.memo)(({
  packageInputStream,
  packageInfo,
  packagePolicyInputStream,
  updatePackagePolicyInputStream,
  inputStreamValidationResults,
  forceShowErrors,
  isEditPage,
  totalStreams
}) => {
  var _packagePolicyInputSt, _customDatasetVar$val, _packagePolicyInputSt2, _uniq;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    params: {
      packagePolicyId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const defaultDataStreamId = (0, _hooks2.useDataStreamId)();
  const containerRef = (0, _react.useRef)(null);
  const isDefaultDatastream = !!defaultDataStreamId && !!packagePolicyInputStream.id && packagePolicyInputStream.id === defaultDataStreamId;
  const isPackagePolicyEdit = !!packagePolicyId;
  const shouldShowStreamsToggles = totalStreams ? totalStreams > 1 : true;
  const customDatasetVar = (_packagePolicyInputSt = packagePolicyInputStream.vars) === null || _packagePolicyInputSt === void 0 ? void 0 : _packagePolicyInputSt[_constants.DATASET_VAR_NAME];
  const customDatasetVarValue = (customDatasetVar === null || customDatasetVar === void 0 ? void 0 : (_customDatasetVar$val = customDatasetVar.value) === null || _customDatasetVar$val === void 0 ? void 0 : _customDatasetVar$val.dataset) || (customDatasetVar === null || customDatasetVar === void 0 ? void 0 : customDatasetVar.value);
  const customDataStreamTypeVar = (_packagePolicyInputSt2 = packagePolicyInputStream.vars) === null || _packagePolicyInputSt2 === void 0 ? void 0 : _packagePolicyInputSt2[_constants.DATA_STREAM_TYPE_VAR_NAME];
  const customDataStreamTypeVarValue = (customDataStreamTypeVar === null || customDataStreamTypeVar === void 0 ? void 0 : customDataStreamTypeVar.value) || packagePolicyInputStream.data_stream.type || 'logs';
  const {
    exists: indexTemplateExists,
    isLoading: isLoadingIndexTemplate
  } = (0, _datastream_hooks.useIndexTemplateExists)((0, _services.getRegistryDataStreamAssetBaseName)({
    dataset: customDatasetVarValue || packageInputStream.data_stream.dataset,
    type: packageInputStream.data_stream.type
  }), isPackagePolicyEdit);

  // only show pipelines and mappings if the matching index template exists
  // in the legacy case (e.g logs package pre 2.0.0) the index template will not exist
  // because we allowed dataset to be customized but didnt create a matching index template
  // for the new dataset.
  const showPipelinesAndMappings = !isLoadingIndexTemplate && indexTemplateExists;
  (0, _react.useEffect)(() => {
    if (isDefaultDatastream && containerRef.current) {
      containerRef.current.scrollIntoView();
    }
  }, [isDefaultDatastream, containerRef]);

  // Split vars into required and advanced
  const [requiredVars, advancedVars] = (0, _react.useMemo)(() => {
    const _requiredVars = [];
    const _advancedVars = [];
    if (packageInputStream.vars && packageInputStream.vars.length) {
      packageInputStream.vars.forEach(varDef => {
        if ((0, _services2.isAdvancedVar)(varDef)) {
          _advancedVars.push(varDef);
        } else {
          _requiredVars.push(varDef);
        }
      });
    }
    return [_requiredVars, _advancedVars];
  }, [packageInputStream]);

  // Errors state
  const hasErrors = forceShowErrors && (0, _services2.validationHasErrors)(inputStreamValidationResults);
  const hasRequiredVarGroupErrors = inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.required_vars;
  const advancedVarsWithErrorsCount = (0, _react.useMemo)(() => advancedVars.filter(({
    name: varName
  }) => {
    var _inputStreamValidatio, _inputStreamValidatio2;
    return inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : (_inputStreamValidatio = inputStreamValidationResults.vars) === null || _inputStreamValidatio === void 0 ? void 0 : (_inputStreamValidatio2 = _inputStreamValidatio[varName]) === null || _inputStreamValidatio2 === void 0 ? void 0 : _inputStreamValidatio2.length;
  }).length, [advancedVars, inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.vars]);
  const {
    data: dataStreamsData
  } = (0, _reactQuery.useQuery)(['datastreams'], () => (0, _hooks.sendGetDataStreams)(), {
    enabled: packageInfo.type === 'input' // Only fetch datastream for input type package
  });
  const datasetList = (_uniq = (0, _lodash.uniq)(dataStreamsData === null || dataStreamsData === void 0 ? void 0 : dataStreamsData.data_streams)) !== null && _uniq !== void 0 ? _uniq : [];
  const datastreams = (0, _sort_datastreams.sortDatastreamsByDataset)(datasetList, packageInfo.name);

  // Showing advanced options toggle state
  const [isShowingAdvanced, setIsShowingAdvanced] = (0, _react.useState)(isDefaultDatastream);
  const hasAdvancedOptions = (0, _react.useMemo)(() => {
    return advancedVars.length > 0 || isPackagePolicyEdit && showPipelinesAndMappings;
  }, [advancedVars.length, isPackagePolicyEdit, showPipelinesAndMappings]);
  const isBiggerScreen = (0, _eui.useIsWithinMinBreakpoint)('xxl');
  const flexWidth = isBiggerScreen ? 7 : 5;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "streamOptions.inputStreams",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
    ref: containerRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: flexWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }, packageInfo.type !== 'input' && shouldShowStreamsToggles && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "streamOptions.switch",
    label: packageInputStream.title,
    disabled: packagePolicyInputStream.keep_enabled,
    checked: packagePolicyInputStream.enabled,
    onChange: e => {
      const enabled = e.target.checked;
      updatePackagePolicyInputStream({
        enabled
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 23
    }
  })), packageInputStream.data_stream.release && packageInputStream.data_stream.release !== 'ga' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_components.InlineReleaseBadge, {
    release: (0, _services.mapPackageReleaseToIntegrationCardRelease)(packageInputStream.data_stream.release),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 23
    }
  })) : null), packageInfo.type !== 'input' && packageInputStream.description && shouldShowStreamsToggles ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 23
    }
  }, packageInputStream.description))) : null, hasRequiredVarGroupErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `${packageInputStream.data_stream.type}-${packageInputStream.data_stream.dataset}-required-vars-group-error`,
    paddingSize: "s",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.requiredVarsGroupErrorText",
      defaultMessage: "One of these settings groups is required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 27
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 23
    }
  }, Object.entries((inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : inputStreamValidationResults.required_vars) || {}).map(([groupName, vars]) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 33
      }
    }, groupName), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 33
      }
    }, vars.map(({
      name
    }) => /*#__PURE__*/_react.default.createElement("li", {
      key: `${groupName}-${name}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 37
      }
    }, name))));
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, requiredVars.map(varDef => {
    var _packagePolicyInputSt3, _varConfigEntry$froze, _inputStreamValidatio3;
    if (!(packagePolicyInputStream !== null && packagePolicyInputStream !== void 0 && packagePolicyInputStream.vars)) return null;
    const {
      name: varName,
      type: varType
    } = varDef;
    const varConfigEntry = (_packagePolicyInputSt3 = packagePolicyInputStream.vars) === null || _packagePolicyInputSt3 === void 0 ? void 0 : _packagePolicyInputSt3[varName];
    const value = varConfigEntry === null || varConfigEntry === void 0 ? void 0 : varConfigEntry.value;
    const frozen = (_varConfigEntry$froze = varConfigEntry === null || varConfigEntry === void 0 ? void 0 : varConfigEntry.frozen) !== null && _varConfigEntry$froze !== void 0 ? _varConfigEntry$froze : false;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      frozen: frozen,
      onChange: newValue => {
        updatePackagePolicyInputStream({
          vars: {
            ...packagePolicyInputStream.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : (_inputStreamValidatio3 = inputStreamValidationResults.vars) === null || _inputStreamValidatio3 === void 0 ? void 0 : _inputStreamValidatio3[varName],
      forceShowErrors: forceShowErrors,
      packageType: packageInfo.type,
      packageName: packageInfo.name,
      datastreams: datastreams,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 21
      }
    }));
  }), (hasAdvancedOptions || packageInfo.type === 'input') && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": "Advanced options",
    size: "xs",
    iconType: isShowingAdvanced ? 'arrowDown' : 'arrowRight',
    onClick: () => setIsShowingAdvanced(!isShowingAdvanced),
    flush: "left",
    "data-test-subj": `advancedStreamOptionsToggle-${packagePolicyInputStream.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",
    defaultMessage: "Advanced options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 27
    }
  }))), !isShowingAdvanced && hasErrors && advancedVarsWithErrorsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: advancedVarsWithErrorsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 29
    }
  }))) : null)), isShowingAdvanced ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, packageInfo.type === 'input' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataStreamTypeInputLabel",
      defaultMessage: "Data Stream Type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 31
      }
    }),
    helpText: isEditPage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyInputOnlyEditDataStreamTypeHelpLabel",
      defaultMessage: "The data stream type cannot be changed for this integration. Create a new integration policy to use a different input type.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 33
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDataStreamTypeHelpLabel",
      defaultMessage: "Select a data stream type for this policy. This setting changes the name of the integration's data stream. {learnMore}.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsNamingScheme,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 39
          }
        }, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceHelpLearnMoreLabel', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 33
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "packagePolicyDataStreamType",
    disabled: isEditPage,
    idSelected: customDataStreamTypeVarValue,
    options: [{
      id: 'logs',
      label: 'Logs'
    }, {
      id: 'metrics',
      label: 'Metrics'
    }, {
      id: 'traces',
      label: 'Traces'
    }],
    onChange: type => {
      updatePackagePolicyInputStream({
        vars: {
          ...packagePolicyInputStream.vars,
          [_constants.DATA_STREAM_TYPE_VAR_NAME]: {
            type: 'string',
            value: type
          }
        }
      });
    },
    name: "dataStreamType",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 29
    }
  }))), advancedVars.map(varDef => {
    var _packagePolicyInputSt4, _packagePolicyInputSt5, _inputStreamValidatio4;
    if (!packagePolicyInputStream.vars) return null;
    const {
      name: varName,
      type: varType
    } = varDef;
    const value = (_packagePolicyInputSt4 = packagePolicyInputStream.vars) === null || _packagePolicyInputSt4 === void 0 ? void 0 : (_packagePolicyInputSt5 = _packagePolicyInputSt4[varName]) === null || _packagePolicyInputSt5 === void 0 ? void 0 : _packagePolicyInputSt5.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: varName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_var_field.PackagePolicyInputVarField, {
      varDef: varDef,
      value: value,
      onChange: newValue => {
        updatePackagePolicyInputStream({
          vars: {
            ...packagePolicyInputStream.vars,
            [varName]: {
              type: varType,
              value: newValue
            }
          }
        });
      },
      errors: inputStreamValidationResults === null || inputStreamValidationResults === void 0 ? void 0 : (_inputStreamValidatio4 = inputStreamValidationResults.vars) === null || _inputStreamValidatio4 === void 0 ? void 0 : _inputStreamValidatio4[varName],
      forceShowErrors: forceShowErrors,
      packageType: packageInfo.type,
      packageName: packageInfo.name,
      datastreams: datastreams,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 409,
        columnNumber: 29
      }
    }));
  }), isPackagePolicyEdit && showPipelinesAndMappings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_datastream_pipelines.PackagePolicyEditorDatastreamPipelines, {
    packageInputStream: packagePolicyInputStream,
    packageInfo: packageInfo,
    customDataset: customDatasetVarValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 29
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_datastream_mappings.PackagePolicyEditorDatastreamMappings, {
    packageInputStream: packagePolicyInputStream,
    packageInfo: packageInfo,
    customDataset: customDatasetVarValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 29
    }
  })))) : null)))));
});