"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatePackagePolicySchema = exports.UpdatePackagePolicyRequestBodySchema = exports.SimplifiedVarsSchema = exports.SimplifiedPackagePolicyPreconfiguredSchema = exports.SimplifiedPackagePolicyInputsSchema = exports.SimplifiedPackagePolicyBaseSchema = exports.SimplifiedCreatePackagePolicyRequestBodySchema = exports.PackagePolicyStatusResponseSchema = exports.PackagePolicySchema = exports.PackagePolicyResponseSchema = exports.PackagePolicyPackageSchema = exports.PackagePolicyNamespaceSchema = exports.PackagePolicyInputsSchema = exports.PackagePolicyBaseSchema = exports.OrphanedPackagePoliciesResponseSchema = exports.NewPackagePolicySchema = exports.ExperimentalDataStreamFeaturesSchema = exports.DryRunPackagePolicySchema = exports.CreatePackagePolicyRequestBodySchema = exports.ConfigRecordSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePolicyNamespaceSchema = exports.PackagePolicyNamespaceSchema = _configSchema.schema.string({
  validate: value => {
    const namespaceValidation = (0, _services.isValidNamespace)(value || '', true);
    if (!namespaceValidation.valid && namespaceValidation.error) {
      return namespaceValidation.error;
    }
  },
  meta: {
    description: "The package policy namespace. Leave blank to inherit the agent policy's namespace."
  }
});
const ConfigRecordSchema = exports.ConfigRecordSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  value: _configSchema.schema.maybe(_configSchema.schema.any()),
  frozen: _configSchema.schema.maybe(_configSchema.schema.boolean())
}), {
  meta: {
    description: 'Package variable (see integration documentation for more information)'
  }
});
const PackagePolicyStreamsSchema = {
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  // BWC < 7.11
  enabled: _configSchema.schema.boolean(),
  keep_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  release: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('ga'), _configSchema.schema.literal('beta'), _configSchema.schema.literal('experimental')])),
  data_stream: _configSchema.schema.object({
    dataset: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    elasticsearch: _configSchema.schema.maybe(_configSchema.schema.object({
      privileges: _configSchema.schema.maybe(_configSchema.schema.object({
        indices: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
      })),
      dynamic_dataset: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      dynamic_namespace: _configSchema.schema.maybe(_configSchema.schema.boolean())
    }))
  }),
  vars: _configSchema.schema.maybe(ConfigRecordSchema),
  config: _configSchema.schema.maybe(ConfigRecordSchema),
  compiled_stream: _configSchema.schema.maybe(_configSchema.schema.any())
};
const PackagePolicyInputsSchema = exports.PackagePolicyInputsSchema = {
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.string(),
  policy_template: _configSchema.schema.maybe(_configSchema.schema.string()),
  enabled: _configSchema.schema.boolean(),
  keep_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  vars: _configSchema.schema.maybe(ConfigRecordSchema),
  config: _configSchema.schema.maybe(ConfigRecordSchema),
  streams: _configSchema.schema.arrayOf(_configSchema.schema.object(PackagePolicyStreamsSchema))
};
const ExperimentalDataStreamFeaturesSchema = exports.ExperimentalDataStreamFeaturesSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  data_stream: _configSchema.schema.string(),
  features: _configSchema.schema.object({
    synthetic_source: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    tsdb: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    doc_value_only_numeric: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    doc_value_only_other: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    }))
  })
}));
const PackagePolicyPackageSchema = exports.PackagePolicyPackageSchema = _configSchema.schema.object({
  name: _configSchema.schema.string({
    meta: {
      description: 'Package name'
    }
  }),
  title: _configSchema.schema.maybe(_configSchema.schema.string()),
  version: _configSchema.schema.string({
    meta: {
      description: 'Package version'
    }
  }),
  experimental_data_stream_features: _configSchema.schema.maybe(ExperimentalDataStreamFeaturesSchema),
  requires_root: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  fips_compatible: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const PackagePolicyBaseSchema = exports.PackagePolicyBaseSchema = {
  name: _configSchema.schema.string({
    meta: {
      description: 'Unique name for the package policy.'
    }
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Package policy description'
    }
  })),
  namespace: _configSchema.schema.maybe(PackagePolicyNamespaceSchema),
  policy_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string({
    meta: {
      description: 'ID of the agent policy which the package policy will be added to.',
      deprecated: true
    }
  })])),
  policy_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'IDs of the agent policies which that package policy will be added to.'
    }
  }))),
  output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  cloud_connector_id: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'ID of the cloud connector associated with this package policy.'
    }
  }))),
  enabled: _configSchema.schema.boolean(),
  is_managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  package: _configSchema.schema.maybe(PackagePolicyPackageSchema),
  inputs: _configSchema.schema.arrayOf(_configSchema.schema.object(PackagePolicyInputsSchema)),
  vars: _configSchema.schema.maybe(ConfigRecordSchema),
  overrides: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.object({
    inputs: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
      validate: val => {
        if (Object.keys(val).some(key => key.match(/^compiled_inputs(\.)?/) || key.match(/^compiled_stream(\.)?/))) {
          return 'Overrides of compiled_inputs and compiled_stream are not allowed';
        }
      }
    }))
  }, {
    meta: {
      description: 'Override settings that are defined in the package policy. The override option should be used only in unusual circumstances and not as a routine procedure.'
    }
  })])),
  supports_agentless: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the package policy belongs to an agentless agent policy.'
    }
  }))),
  supports_cloud_connector: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the package policy supports cloud connectors.'
    }
  }))),
  additional_datastreams_permissions: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: validateAdditionalDatastreamsPermissions,
    meta: {
      description: 'Additional datastream permissions, that will be added to the agent policy.'
    }
  })]))
};
const NewPackagePolicySchema = exports.NewPackagePolicySchema = _configSchema.schema.object({
  ...PackagePolicyBaseSchema,
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const CreatePackagePolicyProps = {
  ...PackagePolicyBaseSchema,
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  package: _configSchema.schema.maybe(PackagePolicyPackageSchema),
  inputs: _configSchema.schema.arrayOf(_configSchema.schema.object({
    ...PackagePolicyInputsSchema,
    streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object(PackagePolicyStreamsSchema)))
  })),
  spaceIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
};
const CreatePackagePolicyRequestBodySchema = exports.CreatePackagePolicyRequestBodySchema = _configSchema.schema.object({
  ...CreatePackagePolicyProps,
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Package policy unique identifier'
    }
  })),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Force package policy creation even if the package is not verified, or if the agent policy is managed.'
    }
  })),
  // supports_agentless is deprecated for package policy creation in favor of agentless policies API
  supports_agentless: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the package policy belongs to an agentless agent policy. Deprecated in favor of the Fleet agentless policies API.',
      deprecated: true
    }
  })))
});
const SimplifiedVarsSchema = exports.SimplifiedVarsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.boolean(), _configSchema.schema.string(), _configSchema.schema.number(), _configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.arrayOf(_configSchema.schema.number()),
// Secrets
_configSchema.schema.object({
  id: _configSchema.schema.string(),
  isSecretRef: _configSchema.schema.boolean()
})])), {
  meta: {
    description: 'Input/stream level variable. Refer to the integration documentation for more information.'
  }
});
const SimplifiedPackagePolicyInputsSchema = exports.SimplifiedPackagePolicyInputsSchema = _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Enable or disable that input. Defaults to `true` (enabled).'
    }
  })),
  vars: _configSchema.schema.maybe(SimplifiedVarsSchema),
  streams: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'Enable or disable that stream. Defaults to `true` (enabled).'
      }
    })),
    vars: _configSchema.schema.maybe(SimplifiedVarsSchema)
  }), {
    meta: {
      description: 'Input streams. Refer to the integration documentation to know which streams are available.'
    }
  }))
}), {
  meta: {
    description: 'Package policy inputs. Refer to the integration documentation to know which inputs are available.'
  }
}));
const VALIDATE_DATASTREAMS_PERMISSION_REGEX = /^(logs)|(metrics)|(traces)|(synthetics)|(profiling)-(.*)$/;
function validateAdditionalDatastreamsPermissions(values) {
  for (const val of values) {
    if (!val.match(VALIDATE_DATASTREAMS_PERMISSION_REGEX)) {
      return `${val} is not a valid datastream permissions, it should match logs|metrics|traces|synthetics|profiling)-*`;
    }
  }
}
const SimplifiedPackagePolicyBaseSchema = exports.SimplifiedPackagePolicyBaseSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Policy unique identifier.'
    }
  })),
  name: _configSchema.schema.string({
    meta: {
      description: 'Unique name for the policy.'
    }
  }),
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Policy description.'
    }
  })),
  namespace: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Policy namespace. When not specified, it inherits the agent policy namespace.'
    }
  })),
  output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  vars: _configSchema.schema.maybe(SimplifiedVarsSchema),
  inputs: SimplifiedPackagePolicyInputsSchema,
  supports_agentless: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the package policy belongs to an agentless agent policy.'
    }
  }))),
  additional_datastreams_permissions: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: validateAdditionalDatastreamsPermissions,
    meta: {
      description: 'Additional datastream permissions, that will be added to the agent policy.'
    }
  })]))
});
const SimplifiedPackagePolicyPreconfiguredSchema = exports.SimplifiedPackagePolicyPreconfiguredSchema = SimplifiedPackagePolicyBaseSchema.extends({
  id: _configSchema.schema.string(),
  package: _configSchema.schema.object({
    name: _configSchema.schema.string()
  })
});
const SimplifiedCreatePackagePolicyRequestBodySchema = exports.SimplifiedCreatePackagePolicyRequestBodySchema = SimplifiedPackagePolicyBaseSchema.extends({
  policy_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()], {
    meta: {
      description: 'Deprecated. Use policy_ids instead.',
      deprecated: true
    }
  })),
  policy_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'IDs of the agent policies which that package policy will be added to.'
    }
  })),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Force package policy creation even if the package is not verified, or if the agent policy is managed.'
    }
  })),
  package: PackagePolicyPackageSchema,
  // supports_agentless is deprecated for package policy creation in favor of agentless policies API
  supports_agentless: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the package policy belongs to an agentless agent policy. Deprecated in favor of the Fleet agentless policies API.',
      deprecated: true
    }
  })))
});
const UpdatePackagePolicyRequestBodySchema = exports.UpdatePackagePolicyRequestBodySchema = _configSchema.schema.object({
  ...CreatePackagePolicyProps,
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  inputs: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    ...PackagePolicyInputsSchema,
    streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object(PackagePolicyStreamsSchema)))
  }))),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const UpdatePackagePolicySchema = exports.UpdatePackagePolicySchema = _configSchema.schema.object({
  ...PackagePolicyBaseSchema,
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const PackagePolicySchema = exports.PackagePolicySchema = _configSchema.schema.object({
  ...PackagePolicyBaseSchema,
  id: _configSchema.schema.string({
    meta: {
      description: 'Package policy unique identifier.'
    }
  }),
  version: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Package policy ES version.'
    }
  })),
  revision: _configSchema.schema.number({
    meta: {
      description: 'Package policy revision.'
    }
  }),
  updated_at: _configSchema.schema.string(),
  updated_by: _configSchema.schema.string(),
  created_at: _configSchema.schema.string(),
  created_by: _configSchema.schema.string(),
  elasticsearch: _configSchema.schema.maybe(_configSchema.schema.object({
    privileges: _configSchema.schema.maybe(_configSchema.schema.object({
      cluster: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
    }))
  })).extendsDeep({
    unknowns: 'allow'
  }),
  inputs: _configSchema.schema.arrayOf(_configSchema.schema.object({
    ...PackagePolicyInputsSchema,
    compiled_input: _configSchema.schema.maybe(_configSchema.schema.any())
  })),
  secret_references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string()
  })))
});
const PackagePolicyResponseSchema = exports.PackagePolicyResponseSchema = PackagePolicySchema.extends({
  vars: _configSchema.schema.maybe(_configSchema.schema.oneOf([ConfigRecordSchema, _configSchema.schema.maybe(SimplifiedVarsSchema)], {
    meta: {
      description: 'Package level variable.'
    }
  })),
  inputs: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.object({
    ...PackagePolicyInputsSchema,
    compiled_input: _configSchema.schema.maybe(_configSchema.schema.any())
  })), SimplifiedPackagePolicyInputsSchema], {
    meta: {
      description: 'Package policy inputs.'
    }
  }),
  spaceIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  agents: _configSchema.schema.maybe(_configSchema.schema.number())
});
const OrphanedPackagePoliciesResponseSchema = exports.OrphanedPackagePoliciesResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(PackagePolicyResponseSchema),
  total: _configSchema.schema.number()
});
const DryRunPackagePolicySchema = exports.DryRunPackagePolicySchema = PackagePolicySchema.extends({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  revision: _configSchema.schema.maybe(_configSchema.schema.number()),
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  updated_by: _configSchema.schema.maybe(_configSchema.schema.string()),
  created_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  created_by: _configSchema.schema.maybe(_configSchema.schema.string()),
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    message: _configSchema.schema.string(),
    key: _configSchema.schema.maybe(_configSchema.schema.string())
  }))),
  missingVars: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}, {
  unknowns: 'allow'
});
const PackagePolicyStatusResponseSchema = exports.PackagePolicyStatusResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  success: _configSchema.schema.boolean(),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  statusCode: _configSchema.schema.maybe(_configSchema.schema.number()),
  body: _configSchema.schema.maybe(_configSchema.schema.object({
    message: _configSchema.schema.string()
  }))
});