"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAwsCloudConnectorVars = isAwsCloudConnectorVars;
exports.isAzureCloudConnectorVars = isAzureCloudConnectorVars;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard to check if vars object contains AWS cloud connector variables
 */
function isAwsCloudConnectorVars(vars) {
  const awsVars = vars;
  return !!(awsVars.role_arn && awsVars.external_id);
}

/**
 * Type guard to check if vars object contains Azure cloud connector variables
 */
function isAzureCloudConnectorVars(vars) {
  const azureVars = vars;
  return !!(azureVars.tenant_id && azureVars.client_id && azureVars.azure_credentials_cloud_connector_id);
}