"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideCarFilePicker = void 0;
exports.getFileNameWithoutExt = getFileNameWithoutExt;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/importer/geo/shapefile_importer/side_car_file_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getFileNameWithoutExt(fileName) {
  const splits = fileName.split('.');
  if (splits.length > 1) {
    splits.pop();
  }
  return splits.join('.');
}
class SideCarFilePicker extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: '',
      isInvalid: false
    });
    (0, _defineProperty2.default)(this, "_onSelect", files => {
      if (!files || files.length === 0) {
        this.setState({
          error: '',
          isInvalid: false
        });
        this.props.onSelect(null);
        return;
      }
      const file = files[0];
      if (!this._isSideCarFileValid(file)) {
        this.setState({
          error: this._getSideCarFileNameError(),
          isInvalid: true
        });
        this.props.onSelect(null);
        return;
      }
      this.setState({
        error: '',
        isInvalid: false
      });
      this.props.onSelect(file);
    });
  }
  _isSideCarFileValid(sideCarFile) {
    return getFileNameWithoutExt(this.props.shapefileName) === getFileNameWithoutExt(sideCarFile.name);
  }
  _getSideCarFileNameError() {
    return _i18n.i18n.translate('xpack.fileUpload.shapefile.sideCarFilePicker.error', {
      defaultMessage: '{ext} expected to be {shapefileName}{ext}',
      values: {
        ext: this.props.ext,
        shapefileName: getFileNameWithoutExt(this.props.shapefileName)
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: this.state.isInvalid,
      error: this.state.error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      initialPromptText: _i18n.i18n.translate('xpack.fileUpload.shapefile.sideCarFilePicker.promptText', {
        defaultMessage: `Select ''{ext}'' file`,
        values: {
          ext: this.props.ext
        }
      }),
      onChange: this._onSelect,
      accept: this.props.ext,
      display: "default",
      isInvalid: this.state.isInvalid,
      "data-test-subj": `shapefileSideCarFilePicker${this.props.ext.replace('.', '_')}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
  }
}
exports.SideCarFilePicker = SideCarFilePicker;