"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbortError = void 0;
exports.isAbortError = isAbortError;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Error thrown when a file upload is aborted.
 */
class AbortError extends Error {
  constructor(message = 'Aborted') {
    super(message);
    this.message = message;
    this.name = 'AbortError';
  }
}
exports.AbortError = AbortError;
function isAbortError(error) {
  return error instanceof AbortError || error instanceof Error && error.name === 'AbortError';
}