"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSeries = exports.defaultReferenceLineColor = void 0;
exports.getColorAssignments = getColorAssignments;
var _lodash = require("lodash");
var _uiTheme = require("@kbn/ui-theme");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _visualization = require("./visualization");
var _data_layers = require("./data_layers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultReferenceLineColor = exports.defaultReferenceLineColor = _uiTheme.euiLightVars.euiColorDarkShade;
function getSplitName(splitAccessors = [], formattedDatatable, row, fieldFormats) {
  return splitAccessors.reduce((splitName, accessor) => {
    if (!formattedDatatable.table.columns.length) return;
    const splitAccessor = (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, formattedDatatable.table.columns);
    const splitFormatterObj = fieldFormats.splitSeriesAccessors[splitAccessor];
    const name = formattedDatatable.formattedColumns[splitAccessor] ? row[splitAccessor] : splitFormatterObj.formatter.convert(row[splitAccessor]);
    if (splitName) {
      return `${splitName} - ${name}`;
    } else {
      return name;
    }
  }, '');
}
const getAllSeries = (formattedDatatable, splitAccessors = [], accessors, columnToLabel, titles, fieldFormats, accessorsCount, multipleLayersWithSplits) => {
  if (!formattedDatatable.table) {
    return [];
  }
  const columnToLabelMap = columnToLabel ? JSON.parse(columnToLabel) : {};
  const allSeries = [];
  formattedDatatable.table.rows.forEach(row => {
    const splitName = getSplitName(splitAccessors, formattedDatatable, row, fieldFormats);
    accessors.forEach(accessor => {
      var _ref, _columnToLabelMap$yAc, _titles$yTitles;
      const yAccessor = (0, _chartExpressionsCommon.getAccessorByDimension)(accessor, formattedDatatable.table.columns);
      const yTitle = (_ref = (_columnToLabelMap$yAc = columnToLabelMap[yAccessor]) !== null && _columnToLabelMap$yAc !== void 0 ? _columnToLabelMap$yAc : titles === null || titles === void 0 ? void 0 : (_titles$yTitles = titles.yTitles) === null || _titles$yTitles === void 0 ? void 0 : _titles$yTitles[yAccessor]) !== null && _ref !== void 0 ? _ref : null;
      let name = yTitle;
      if (splitName) {
        name = accessorsCount > 1 || multipleLayersWithSplits ? `${splitName} - ${yTitle}` : splitName;
      }
      if (!allSeries.includes(name)) {
        allSeries.push(name);
      }
    });
  });
  return allSeries;
};

/**
 * This function joins every data series name available on each layer by the same color palette.
 * The returned function `getRank` should return the position of a series name in this unified list by palette.
 */
exports.getAllSeries = getAllSeries;
function getColorAssignments(layers, titles, fieldFormats, formattedDatatables) {
  const layersPerPalette = {};
  layers.forEach(layer => {
    var _layer$palette;
    if (!(0, _visualization.isDataLayer)(layer)) {
      return;
    }
    const palette = ((_layer$palette = layer.palette) === null || _layer$palette === void 0 ? void 0 : _layer$palette.name) || 'default';
    if (!layersPerPalette[palette]) {
      layersPerPalette[palette] = [];
    }
    layersPerPalette[palette].push(layer);
  });
  const multipleLayersWithSplits = (0, _data_layers.hasMultipleLayersWithSplits)(layers);
  return (0, _lodash.mapValues)(layersPerPalette, paletteLayers => {
    const seriesPerLayer = paletteLayers.map(layer => {
      const allSeries = getAllSeries(formattedDatatables[layer.layerId], layer.splitAccessors, layer.accessors, layer.columnToLabel, titles[layer.layerId], fieldFormats[layer.layerId], layer.accessors.length, multipleLayersWithSplits) || [];
      return {
        numberOfSeries: allSeries.length,
        allSeries
      };
    });
    const totalSeriesCount = seriesPerLayer.reduce((sum, perLayer) => sum + perLayer.numberOfSeries, 0);
    return {
      totalSeriesCount,
      getRank(layerId, seriesName) {
        const layerIndex = paletteLayers.findIndex(layer => layerId === layer.layerId);
        const currentSeriesPerLayer = seriesPerLayer[layerIndex];
        const rank = currentSeriesPerLayer.allSeries.indexOf(seriesName);
        return (layerIndex === 0 ? 0 : seriesPerLayer.slice(0, layerIndex).reduce((sum, perLayer) => sum + perLayer.numberOfSeries, 0)) + (rank !== -1 ? rank : 0);
      }
    };
  });
}