"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegendActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _constants = require("@kbn/cell-actions/constants");
var _filter_helpers = require("./filter_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_partition_vis/public/utils/get_legend_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasFilterCellAction = actions => {
  return actions.some(({
    type
  }) => type === _constants.FILTER_CELL_ACTION_TYPE);
};
const getLegendActions = (canFilter, getFilterEventData, onFilter, columnCellValueActions, visParams, visData, formatter) => {
  return ({
    series: [pieSeries]
  }) => {
    var _columnCellValueActio;
    const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
    const [isFilterable, setIsFilterable] = (0, _react.useState)(true);
    const filterData = (0, _react.useMemo)(() => getFilterEventData(pieSeries), [pieSeries]);
    const columnIndex = (0, _react.useMemo)(() => (0, _filter_helpers.getSeriesValueColumnIndex)(pieSeries.key, visData), [pieSeries]);
    const [ref, onClose] = (0, _charts.useLegendAction)();
    (0, _react.useEffect)(() => {
      if (!canFilter || !filterData) {
        setIsFilterable(false);
        return;
      }
      (async () => setIsFilterable(await canFilter(filterData)))();
    }, [filterData]);
    if (columnIndex === -1) {
      return null;
    }
    const title = (0, _filter_helpers.getFilterPopoverTitle)(visParams, visData, columnIndex, formatter.deserialize,
    // FIXME key could be a RangeKey see https://github.com/elastic/kibana/issues/153437
    pieSeries.key);
    const compatibleCellActions = (_columnCellValueActio = columnCellValueActions[columnIndex]) !== null && _columnCellValueActio !== void 0 ? _columnCellValueActio : [];
    const panelItems = [];
    if (!hasFilterCellAction(compatibleCellActions) && isFilterable && filterData) {
      panelItems.push({
        name: _i18n.i18n.translate('expressionPartitionVis.legend.filterForValueButtonAriaLabel', {
          defaultMessage: 'Filter for'
        }),
        'data-test-subj': `legend-${title}-filterIn`,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "plusInCircle",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 17
          }
        }),
        onClick: () => {
          setPopoverOpen(false);
          onFilter(filterData);
        }
      }, {
        name: _i18n.i18n.translate('expressionPartitionVis.legend.filterOutValueButtonAriaLabel', {
          defaultMessage: 'Filter out'
        }),
        'data-test-subj': `legend-${title}-filterOut`,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "minusInCircle",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 17
          }
        }),
        onClick: () => {
          setPopoverOpen(false);
          onFilter(filterData, true);
        }
      });
    }
    const columnMeta = visData.columns[columnIndex].meta;
    compatibleCellActions.forEach(action => {
      panelItems.push({
        name: action.displayName,
        'data-test-subj': `legend-${title}-${action.id}`,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: action.iconType,
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 15
          }
        }),
        onClick: () => {
          action.execute([{
            columnMeta,
            value: pieSeries.key
          }]);
          setPopoverOpen(false);
        }
      });
    });
    if (panelItems.length === 0) {
      return null;
    }
    const panels = [{
      id: 'main',
      title,
      items: panelItems
    }];
    const Button = /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: 0,
      ref: ref,
      role: "button",
      "aria-pressed": "false",
      css: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        height: '100%',
        marginLeft: 4,
        marginRight: 4
      },
      "data-test-subj": `legend-${title}`,
      onKeyPress: () => setPopoverOpen(!popoverOpen),
      onClick: () => setPopoverOpen(!popoverOpen),
      "aria-label": _i18n.i18n.translate('expressionPartitionVis.legend.legendActionsAria', {
        defaultMessage: 'Legend actions'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "boxesVertical",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: Button,
      isOpen: popoverOpen,
      closePopover: () => {
        setPopoverOpen(false);
        onClose();
      },
      panelPaddingSize: "none",
      anchorPosition: "upLeft",
      title: _i18n.i18n.translate('expressionPartitionVis.legend.filterOptionsLegend', {
        defaultMessage: '{legendDataLabel}, filter options',
        values: {
          legendDataLabel: title
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: "main",
      panels: panels,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }));
  };
};
exports.getLegendActions = getLegendActions;