"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.heatmapRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _visualizationsCommon = require("@kbn/visualizations-common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _analytics = require("@kbn/analytics");
var _ebtTools = require("@kbn/ebt-tools");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _react2 = require("@emotion/react");
var _common = require("../../common");
var _services = require("../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_heatmap/public/expression_renderers/heatmap_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const heatmapContainerCss = ({
  euiTheme
}) => (0, _react2.css)({
  width: '100%',
  height: '100%',
  padding: euiTheme.size.s,
  // the FocusTrap is adding extra divs which are making the visualization redraw twice
  // with a visible glitch. This make the chart library resilient to this extra reflow
  overflow: 'auto hidden',
  userSelect: 'text'
});
const heatmapRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_HEATMAP_NAME,
  displayName: _i18n.i18n.translate('expressionHeatmap.visualizationName', {
    defaultMessage: 'Heatmap'
  }),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const performanceTracker = (0, _ebtTools.createPerformanceTracker)({
      type: _ebtTools.PERFORMANCE_TRACKER_TYPES.PANEL,
      subType: _common.EXPRESSION_HEATMAP_NAME
    });
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.PRE_RENDER);
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const onClickValue = data => {
      handlers.event({
        name: 'filter',
        data
      });
    };
    const onSelectRange = data => {
      handlers.event({
        name: 'brush',
        data
      });
    };
    const onClickMultiValue = data => {
      handlers.event({
        name: 'multiFilter',
        data
      });
    };
    const renderComplete = () => {
      performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_COMPLETE);
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}`, config.canNavigateToLens ? `render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    const timeZone = (0, _visualizationsCommon.getTimeZone)((0, _services.getUISettings)());
    const {
      HeatmapComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/heatmap_component')));
    const {
      isInteractive
    } = handlers;
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_START);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-scrollBar",
      css: heatmapContainerCss,
      "data-test-subj": "heatmapChart",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(HeatmapComponent, (0, _extends2.default)({}, config, {
      onClickValue: onClickValue,
      onSelectRange: onSelectRange,
      timeZone: timeZone,
      datatableUtilities: (0, _services.getDatatableUtilities)(),
      formatFactory: (0, _services.getFormatService)().deserialize,
      chartsThemeService: plugins.charts.theme,
      paletteService: (0, _services.getPaletteService)(),
      renderComplete: renderComplete,
      uiState: handlers.uiState,
      interactive: isInteractive(),
      chartsActiveCursorService: plugins.charts.activeCursor,
      syncTooltips: config.syncTooltips,
      syncCursor: config.syncCursor,
      onClickMultiValue: onClickMultiValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    })))), domNode);
  }
});
exports.heatmapRenderer = heatmapRenderer;