"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GaugeComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/charts-plugin/public");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
var _utils = require("./utils");
var _icons = require("./utils/icons");
var _use_gauge_size_by_type = require("./utils/use_gauge_size_by_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_gauge/public/components/gauge_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRANSPARENT = `rgba(255,255,255,0)`;
function normalizeBands({
  colors,
  stops,
  range,
  rangeMax,
  rangeMin
}, {
  min,
  max
}) {
  if (!stops.length) {
    const step = (max - min) / colors.length;
    return [min, ...colors.map((_, i) => min + (i + 1) * step)];
  }
  let firstRanges = [min];
  let lastRanges = [max];
  let correctMin = rangeMin;
  let correctMax = rangeMax;
  if (range === 'percent') {
    correctMin = min + rangeMin * ((max - min) / 100);
    correctMax = min + rangeMax * ((max - min) / 100);
  }
  if (correctMin > min && isFinite(correctMin)) {
    firstRanges = [min, correctMin];
  }
  if (correctMax < max && isFinite(correctMax)) {
    lastRanges = [correctMax, max];
  }
  if (range === 'percent') {
    const filteredStops = stops.filter(stop => stop > 0 && stop < 100);
    return [...firstRanges, ...filteredStops.map(step => min + step * ((max - min) / 100)), ...lastRanges];
  }
  const orderedStops = stops.filter((stop, i) => stop < max && stop > min);
  return [...firstRanges, ...orderedStops, ...lastRanges];
}
const toPercents = (min, max) => v => (v - min) / (max - min);
function normalizeBandsLegacy({
  colors,
  stops
}, value) {
  const min = stops[0];
  const max = stops[stops.length - 1];
  const convertToPercents = toPercents(min, max);
  const normalizedStops = stops.map(convertToPercents);
  if (max < value) {
    normalizedStops.push(convertToPercents(value));
  }
  return normalizedStops;
}
function actualValueToPercentsLegacy({
  stops
}, value) {
  const min = stops[0];
  const max = stops[stops.length - 1];
  const convertToPercents = toPercents(min, max);
  return convertToPercents(value);
}
function getTitle(majorMode, major, fallbackTitle) {
  if (majorMode === _common.GaugeLabelMajorModes.NONE) {
    return '';
  }
  if (majorMode === _common.GaugeLabelMajorModes.AUTO) {
    return fallbackTitle || '';
  }
  return major || fallbackTitle || '';
}
const getPreviousSectionValue = (value, bands) => {
  // bands value is equal to the stop. The purpose of this value is coloring the previous section, which is smaller, then the band.
  // So, the smaller value should be taken. For the first element -1, for the next - middle value of the previous section.

  let prevSectionValue = value - 1;
  const valueIndex = bands.indexOf(value);
  const prevBand = bands[valueIndex - 1];
  const curBand = bands[valueIndex];
  if (valueIndex > 0) {
    prevSectionValue = value - (curBand - prevBand) / 2;
  }
  return prevSectionValue;
};
function getTicksLabels(baseStops) {
  const tenPercentRange = (Math.max(...baseStops) - Math.min(...baseStops)) * 0.1;
  const lastIndex = baseStops.length - 1;
  return baseStops.filter((stop, i) => {
    if (i === 0 || i === lastIndex) {
      return true;
    }
    return !(stop - baseStops[i - 1] < tenPercentRange || baseStops[lastIndex] - stop < tenPercentRange);
  });
}
function getTicks(ticksPosition, colorBands) {
  if (ticksPosition === _common.GaugeTicksPositions.HIDDEN) {
    return [];
  }
  if (ticksPosition === _common.GaugeTicksPositions.BANDS && colorBands) {
    return colorBands && getTicksLabels(colorBands);
  }
}
const GaugeComponent = ({
  data,
  args,
  uiState,
  formatFactory,
  paletteService,
  chartsThemeService,
  renderComplete,
  overrides,
  setChartSize
}) => {
  var _findAccessor, _metricColumn$meta, _metricColumn$meta$pa, _metricColumn$meta2, _ref, _palette$params$stops, _window$_echDebugStat;
  const {
    shape: gaugeType,
    palette,
    colorMode,
    labelMinor,
    labelMajor,
    labelMajorMode,
    ticksPosition,
    commonLabel
  } = args;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartBaseTheme = chartsThemeService.useChartsBaseTheme();
  (0, _use_gauge_size_by_type.useGaugeSizeByType)(gaugeType, setChartSize);
  const getColor = (0, _react.useCallback)((value, paletteConfig, bands, percentageMode) => {
    var _paletteConfig$params, _paletteConfig$params2, _paletteService$get$g, _paletteService$get, _paletteConfig$name;
    const stops = percentageMode ? bands.map(v => v * 100) : (_paletteConfig$params = (_paletteConfig$params2 = paletteConfig.params) === null || _paletteConfig$params2 === void 0 ? void 0 : _paletteConfig$params2.stops) !== null && _paletteConfig$params !== void 0 ? _paletteConfig$params : [];
    return (_paletteService$get$g = (_paletteService$get = paletteService.get((_paletteConfig$name = paletteConfig === null || paletteConfig === void 0 ? void 0 : paletteConfig.name) !== null && _paletteConfig$name !== void 0 ? _paletteConfig$name : 'custom')).getColorForValue) === null || _paletteService$get$g === void 0 ? void 0 : _paletteService$get$g.call(_paletteService$get, value, {
      ...paletteConfig.params,
      stops
    }, (0, _utils.computeMinMax)(paletteConfig, bands));
  }, [paletteService]);

  // Legacy chart was not formatting numbers, when was forming overrideColors.
  // To support the behavior of the color overriding, it is required to skip all the formatting, except percent.
  const overrideColor = (0, _react.useCallback)((value, bands, formatter) => {
    var _uiState$get, _formatter$convert, _formatter$convert2;
    const overrideColors = (_uiState$get = uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors')) !== null && _uiState$get !== void 0 ? _uiState$get : {};
    const valueIndex = bands.findIndex((band, index, allBands) => {
      if (index === allBands.length - 1) {
        return false;
      }
      return value >= band && value < allBands[index + 1];
    });
    if (valueIndex < 0 || valueIndex === bands.length - 1) {
      return undefined;
    }
    const curValue = bands[valueIndex];
    const nextValue = bands[valueIndex + 1];
    return overrideColors[`${(_formatter$convert = formatter === null || formatter === void 0 ? void 0 : formatter.convert(curValue)) !== null && _formatter$convert !== void 0 ? _formatter$convert : curValue} - ${(_formatter$convert2 = formatter === null || formatter === void 0 ? void 0 : formatter.convert(nextValue)) !== null && _formatter$convert2 !== void 0 ? _formatter$convert2 : nextValue}`];
  }, [uiState]);
  const onRenderChange = (0, _react.useCallback)((isRendered = true) => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const accessors = (0, _utils.getAccessorsFromArgs)(args, data.columns);
  const metricAccessor = accessors === null || accessors === void 0 ? void 0 : accessors.metric;
  if (!metricAccessor) {
    // Chart is not ready
    return null;
  }
  const metricColumn = data.columns.find(col => col.id === metricAccessor);
  const chartData = data.rows.filter(v => typeof v[metricAccessor] === 'number' || Array.isArray(v[metricAccessor]));
  const row = chartData === null || chartData === void 0 ? void 0 : chartData[0];
  const metricValue = args.metric ? (0, _utils.getValueFromAccessor)(metricAccessor, row) : undefined;
  const metricName = (_findAccessor = (0, _chartExpressionsCommon.findAccessor)(metricAccessor, data.columns)) === null || _findAccessor === void 0 ? void 0 : _findAccessor.name;
  const icon = (0, _icons.getGaugeIconByType)(gaugeType);
  if (typeof metricValue !== 'number') {
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      renderComplete: onRenderChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 12
      }
    });
  }
  const goal = accessors.goal ? (0, _utils.getValueFromAccessor)(accessors.goal, row) : undefined;
  const min = (0, _utils.getMinValue)(row, accessors, palette === null || palette === void 0 ? void 0 : palette.params, args.respectRanges);
  const max = (0, _utils.getMaxValue)(row, accessors, palette === null || palette === void 0 ? void 0 : palette.params, args.respectRanges);
  if (min === max) {
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "expressionGauge.renderer.chartCannotRenderEqual",
        defaultMessage: "Minimum and maximum values may not be equal",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 278,
          columnNumber: 11
        }
      }),
      renderComplete: onRenderChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 7
      }
    });
  }
  if (min > max) {
    return /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "expressionGauge.renderer.chartCannotRenderMinGreaterMax",
        defaultMessage: "Minimum value may not be greater than maximum value",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 11
        }
      }),
      renderComplete: onRenderChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 7
      }
    });
  }
  const customMetricFormatParams = (0, _chartExpressionsCommon.isVisDimension)(args.metric) ? args.metric.format : undefined;
  const tableMetricFormatParams = metricColumn !== null && metricColumn !== void 0 && (_metricColumn$meta = metricColumn.meta) !== null && _metricColumn$meta !== void 0 && (_metricColumn$meta$pa = _metricColumn$meta.params) !== null && _metricColumn$meta$pa !== void 0 && _metricColumn$meta$pa.params ? metricColumn === null || metricColumn === void 0 ? void 0 : (_metricColumn$meta2 = metricColumn.meta) === null || _metricColumn$meta2 === void 0 ? void 0 : _metricColumn$meta2.params : undefined;
  const defaultMetricFormatParams = args.metric && (0, _chartExpressionsCommon.getFormatByAccessor)(args.metric, data.columns) || {
    id: 'number',
    params: {
      pattern: max - min > 5 ? '0,0' : '0,0.0'
    }
  };
  const tickFormatter = formatFactory((_ref = customMetricFormatParams !== null && customMetricFormatParams !== void 0 ? customMetricFormatParams : tableMetricFormatParams) !== null && _ref !== void 0 ? _ref : defaultMetricFormatParams);
  let bands = palette !== null && palette !== void 0 && palette.params ? normalizeBands(palette === null || palette === void 0 ? void 0 : palette.params, {
    min,
    max
  }) : [min, max];
  let actualValue = metricValue;
  if (args.percentageMode && palette !== null && palette !== void 0 && palette.params && palette !== null && palette !== void 0 && (_palette$params$stops = palette.params.stops) !== null && _palette$params$stops !== void 0 && _palette$params$stops.length) {
    bands = normalizeBandsLegacy(palette === null || palette === void 0 ? void 0 : palette.params, actualValue);
    actualValue = actualValueToPercentsLegacy(palette === null || palette === void 0 ? void 0 : palette.params, actualValue);
  }
  const ticks = getTicks(ticksPosition, bands);
  const labelMajorTitle = getTitle(labelMajorMode, labelMajor, metricColumn === null || metricColumn === void 0 ? void 0 : metricColumn.name);
  const colorFn = val => {
    var _args$palette$params$, _args$palette, _args$palette$params, _getColor;
    const value = getPreviousSectionValue(val, bands);
    const overridedColor = overrideColor(value, args.percentageMode ? bands : (_args$palette$params$ = (_args$palette = args.palette) === null || _args$palette === void 0 ? void 0 : (_args$palette$params = _args$palette.params) === null || _args$palette$params === void 0 ? void 0 : _args$palette$params.stops) !== null && _args$palette$params$ !== void 0 ? _args$palette$params$ : [], args.percentageMode ? tickFormatter : undefined);
    if (overridedColor) {
      return overridedColor;
    }
    return args.palette ? (_getColor = getColor(value, args.palette, bands, args.percentageMode)) !== null && _getColor !== void 0 ? _getColor : TRANSPARENT : TRANSPARENT;
  };
  const getColorConfig = () => {
    if (colorMode === _common.GaugeColorModes.NONE) return [euiTheme.colors.lightShade, euiTheme.colors.lightShade];
    return {
      steps: bands,
      colors: bands.map(b => colorFn(b)).slice(1)
    };
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        flex: 1 1 0;
        display: flex;
        flex-direction: column;
        height: 100%; /* it is used for rendering in Canvas.*/
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, (0, _extends2.default)({}, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'chart'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    noResults: /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
      icon: icon,
      renderComplete: onRenderChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 22
      }
    }),
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    theme: [{
      background: {
        color: 'transparent'
      }
    }],
    baseTheme: chartBaseTheme,
    ariaLabel: args.ariaLabel,
    ariaUseDefaultSummary: !args.ariaLabel,
    onRenderChange: onRenderChange,
    locale: _i18n.i18n.getLocale()
  }, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'settings'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Bullet, {
    id: "bullet",
    subtype: (0, _utils.getSubtypeByGaugeType)(gaugeType),
    colorBands: getColorConfig(),
    valueLabels: {
      active: _i18n.i18n.translate('expressionGauge.tooltip.valueLabel.active', {
        defaultMessage: 'Current'
      }),
      value: metricName || _i18n.i18n.translate('expressionGauge.tooltip.valueLabel.value', {
        defaultMessage: 'Metric'
      }),
      target: _i18n.i18n.translate('expressionGauge.tooltip.valueLabel.target', {
        defaultMessage: 'Goal'
      })
    },
    data: [[{
      target: goal && goal >= bands[0] && goal <= bands[bands.length - 1] ? goal : undefined,
      value: actualValue,
      title: labelMajorTitle,
      subtitle: labelMinor,
      domain: [min, max],
      ticks: ticks ? () => ticks : undefined,
      valueFormatter: tickValue => tickFormatter.convert(tickValue),
      tickFormatter: tickValue => tickFormatter.convert(tickValue)
    }]],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  })), commonLabel && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            width: 100%;
            text-align: center;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 9
    }
  }, commonLabel));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = exports.GaugeComponent = GaugeComponent;