"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextReportDefinitionField = TextReportDefinitionField;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/text_report_definition_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TextReportDefinitionField({
  series,
  field,
  seriesConfig,
  onChange
}) {
  var _labels$field;
  const {
    textReportDefinitions: selectedTextReportDefinitions = {}
  } = series;
  const {
    labels
  } = seriesConfig;
  const label = (_labels$field = labels[field]) !== null && _labels$field !== void 0 ? _labels$field : field;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "o11yTextReportDefinitionFieldFieldText",
    placeholder: _i18n.i18n.translate('xpack.exploratoryView.textDefinitionField.placeholder.search', {
      defaultMessage: 'Search {label}',
      values: {
        label
      }
    }),
    value: selectedTextReportDefinitions === null || selectedTextReportDefinitions === void 0 ? void 0 : selectedTextReportDefinitions[field],
    onChange: e => onChange(field, e.target.value),
    compressed: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
}