"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHOOSE_BREAKDOWN_FIELD = void 0;
exports.LabelsBreakdown = LabelsBreakdown;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _use_series_storage = require("../../hooks/use_series_storage");
var _constants = require("../../configurations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/breakdown/label_breakdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LabelsBreakdown({
  series,
  seriesId
}) {
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const labelFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => field.name.startsWith('labels.'));
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    breakdown
  } = series;
  const hasLabelBreakdown = breakdown === _constants.LABEL_FIELDS_BREAKDOWN || (breakdown === null || breakdown === void 0 ? void 0 : breakdown.startsWith('labels.'));
  if (!hasLabelBreakdown) {
    return null;
  }
  const labelFieldOptions = labelFields === null || labelFields === void 0 ? void 0 : labelFields.map(field => {
    return {
      label: field.name,
      value: field.name
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 200
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: labelFieldOptions === null || labelFieldOptions === void 0 ? void 0 : labelFieldOptions.filter(labelField => labelField.label === breakdown),
    options: labelFieldOptions,
    placeholder: CHOOSE_BREAKDOWN_FIELD,
    "aria-label": CHOOSE_BREAKDOWN_FIELD,
    onChange: value => {
      var _value$0$label, _value$;
      setSeries(seriesId, {
        ...series,
        breakdown: (_value$0$label = value === null || value === void 0 ? void 0 : (_value$ = value[0]) === null || _value$ === void 0 ? void 0 : _value$.label) !== null && _value$0$label !== void 0 ? _value$0$label : _constants.LABEL_FIELDS_BREAKDOWN
      });
    },
    singleSelection: {
      asPlainText: true
    },
    isInvalid: series.breakdown === _constants.LABEL_FIELDS_BREAKDOWN,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
}
const CHOOSE_BREAKDOWN_FIELD = exports.CHOOSE_BREAKDOWN_FIELD = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.labelField', {
  defaultMessage: 'Choose label field'
});